### $Id: BodyWeight.R,v 1.4 2000/07/03 18:22:44 bates Exp $
### Data over time on the bodyweight of rats on different diets
### Hand and Crowder (1996), Table A.1, p. 171
"BodyWeight" <-
  structure(list(
weight = c(240, 250, 255, 260, 262, 258, 266, 
  266, 265, 272, 278, 225, 230, 230, 232, 240, 240, 243, 244, 238, 
  247, 245, 245, 250, 250, 255, 262, 265, 267, 267, 264, 268, 269, 
  260, 255, 255, 265, 265, 268, 270, 272, 274, 273, 275, 255, 260, 
  255, 270, 270, 273, 274, 273, 276, 278, 280, 260, 265, 270, 275, 
  275, 277, 278, 278, 284, 279, 281, 275, 275, 260, 270, 273, 274, 
  276, 271, 282, 281, 284, 245, 255, 260, 268, 270, 265, 265, 267, 
  273, 274, 278, 410, 415, 425, 428, 438, 443, 442, 446, 456, 468, 
  478, 405, 420, 430, 440, 448, 460, 458, 464, 475, 484, 496, 445, 
  445, 450, 452, 455, 455, 451, 450, 462, 466, 472, 555, 560, 565, 
  580, 590, 597, 595, 595, 612, 618, 628, 470, 465, 475, 485, 487, 
  493, 493, 504, 507, 518, 525, 535, 525, 530, 533, 535, 540, 525, 
  530, 543, 544, 559, 520, 525, 530, 540, 543, 546, 538, 544, 553, 
  555, 548, 510, 510, 520, 515, 530, 538, 535, 542, 550, 553, 569),
Time = c(1, 8, 15, 22, 29, 36, 43, 44, 50, 57, 64, 1, 8, 15, 
  22, 29, 36, 43, 44, 50, 57, 64, 1, 8, 15, 22, 29, 36, 43, 44, 
  50, 57, 64, 1, 8, 15, 22, 29, 36, 43, 44, 50, 57, 64, 1, 8, 15, 
  22, 29, 36, 43, 44, 50, 57, 64, 1, 8, 15, 22, 29, 36, 43, 44, 
  50, 57, 64, 1, 8, 15, 22, 29, 36, 43, 44, 50, 57, 64, 1, 8, 15, 
  22, 29, 36, 43, 44, 50, 57, 64, 1, 8, 15, 22, 29, 36, 43, 44, 
  50, 57, 64, 1, 8, 15, 22, 29, 36, 43, 44, 50, 57, 64, 1, 8, 15, 
  22, 29, 36, 43, 44, 50, 57, 64, 1, 8, 15, 22, 29, 36, 43, 44, 
  50, 57, 64, 1, 8, 15, 22, 29, 36, 43, 44, 50, 57, 64, 1, 8, 15, 
  22, 29, 36, 43, 44, 50, 57, 64, 1, 8, 15, 22, 29, 36, 43, 44, 
  50, 57, 64, 1, 8, 15, 22, 29, 36, 43, 44, 50, 57, 64),
Rat = structure(ordered(c(4, 
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
  7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 5, 5, 5, 5, 5, 5, 5, 5, 
  5, 5, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
  9, 9, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 15, 15, 15, 15, 15, 15, 15, 15, 
  15, 15, 15, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 16, 16, 
  16, 16, 16, 16, 16, 16, 16, 16, 16), levels=1:16),
  class = c("ordered", "factor"),
  .Label = c("2", "3", "4", "1", "8", "5", "6", "7", "11", "9", "10",
    "12", "13", "15", "14", "16")),
Diet = structure(factor(c(1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3), levels=1:3), class = "factor",
  .Label = c("1", "2", "3"))),
row.names = 1:176, outer = ~ Diet,
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = weight ~ Time | Rat,
labels = list(x = "Time", y = "Body weight"),
units = list(x = "(days)", y = "(g)"),
outer = ~ Diet,
FUN = function(x) max(x, na.rm = TRUE),
order.groups = TRUE)
