% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztdraw_sc_linear.R
\name{ztdraw_sc_linear}
\alias{ztdraw_sc_linear}
\title{Simulate \code{size} samples from a zero-truncated non homogeneous Poisson Point Process (zt-NHPPP) from
(t_min, t_max) with linear intensity function}
\usage{
ztdraw_sc_linear(
  alpha = 1,
  beta = 0,
  range_t = c(0, 10),
  rng_stream = NULL,
  atmost1 = FALSE
)
}
\arguments{
\item{alpha}{(double) the intercept}

\item{beta}{(double) the slope}

\item{range_t}{(vector, double) min and max of the time interval}

\item{rng_stream}{(\code{rstream}) an \code{rstream} object}

\item{atmost1}{(boolean) draw 1 event time}
}
\value{
a vector of at least 1 event times
}
\description{
Sample zero-truncated NHPPP times from a linear intensity function
using the inversion method, optionally using an \code{rstream}
generator
}
\examples{
x <- ztdraw_sc_linear(alpha = 0, beta = 0.2)

}
