% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_sc_step.R
\name{draw_sc_step}
\alias{draw_sc_step}
\title{Simulate a piecewise constant-rate Poisson Point Process over \verb{(t_min, t_max]} (inversion method)
The intervals need not have the same length.}
\usage{
draw_sc_step(
  lambda_vector = rep(1, 5),
  times_vector = c(0:5),
  rng_stream = NULL,
  atmost1 = FALSE,
  atleast1 = FALSE
)
}
\arguments{
\item{lambda_vector}{(scalar, double) \code{K} constant rates, one per interval}

\item{times_vector}{(vector, double) \code{K+1} time points defining \code{K} intervals
of constant rates:
\verb{[t_1 = range_t[1],       t_2)}: the first interval
\verb{[t_k,                t_\{k+1\})}: the \code{k}-th interval
\verb{[t_\{K\}, t_\{K+1\} = range_t[2])}: the \code{K}-th (last) interval}

\item{rng_stream}{an \code{rstream} object}

\item{atmost1}{boolean, draw at most 1 event time}

\item{atleast1}{boolean, draw at least 1 event time}
}
\value{
a vector of event times t
if no events realize, it will have 0 length
}
\description{
Simulate a piecewise constant-rate Poisson Point Process over \verb{(t_min, t_max]} (inversion method)
The intervals need not have the same length.
}
\examples{
x <- draw_sc_step(lambda_vector = rep(1, 5), times_vector = c(0:5))
}
