% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes_options.R
\name{nhanesOptions}
\alias{nhanesOptions}
\title{Options for the nhanesA package}
\usage{
nhanesOptions(...)
}
\arguments{
\item{...}{either one or more named arguments giving options to be
set (in the form \code{key = value}), or a single unnamed
character string to retrieve a setting.}
}
\value{
When retrieving an option, the value of the option, or
    \code{NULL} if the option has not been set. When setting one
    or more options, a list (invisibly) containing the previous
    values (possibly \code{NULL}) of the options being set.
}
\description{
Set and retrieve global options controlling the behaviour of
certain functions in the package.
}
\details{
The 'nhanesOptions()' function can be used in two forms, to set or
get options. Options can be set using 'nhanesOptions(key1 =
value1, key2 = value2)'. Options can be retrieved (one at a time)
using 'nhanesOptions("key")'. When called with no arguments, all
currently set options are returned as a list.

Options currently used in the package are 'use.db' (logical flag
controlling whether a database should be used if available), and
'log.access', a logical flag that logs any attempted URL access by
printing the URL).
}
\examples{
 nhanesOptions(foo = "bar")
 nhanesOptions()
 print(nhanesOptions(foo = NULL))
}
\author{
Deepayan Sarkar <deepayan.sarkar@gmail.com>
}
