% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ortho2.R
\name{ortho2}
\alias{ortho2}
\title{Orthographic Display, added options}
\usage{
ortho2(
  x,
  y = NULL,
  xyz = NULL,
  w = 1,
  col = gray(0:64/64),
  col.y = oro.nifti::hotmetal(),
  zlim = NULL,
  zlim.y = NULL,
  NA.x = FALSE,
  NA.y = TRUE,
  crosshairs = TRUE,
  col.crosshairs = "red",
  xlab = "",
  ylab = "",
  axes = FALSE,
  oma = c(0, 0, 0, ifelse(ycolorbar, 5, 0)),
  mar = rep(0, 4),
  bg = "black",
  text = NULL,
  text.color = "white",
  text.cex = 2,
  text.x = 32,
  text.y = 32,
  add.orient = FALSE,
  mfrow = c(2, 2),
  ybreaks = NULL,
  breaks = NULL,
  addlegend = FALSE,
  leg.x = 32,
  leg.y = 32,
  legend,
  leg.col,
  leg.title = NULL,
  leg.cex,
  window = NULL,
  ycolorbar = FALSE,
  clabels = TRUE,
  add = TRUE,
  pdim = NULL,
  useRaster = is.null(y),
  mask = NULL,
  ...
)
}
\arguments{
\item{x}{is an object of class nifti or similar.}

\item{y}{is an object of class nifti or similar for the overlay.}

\item{xyz}{is the coordinate for the center of the crosshairs.}

\item{w}{is the time point to be displayed (4D arrays only).}

\item{col}{is grayscale (by default).}

\item{col.y}{is hotmetal (by default).}

\item{zlim}{is the minimum and maximum `z' values passed into image.}

\item{zlim.y}{is the minimum and maximum `z' values passed into image 
for the overlay.}

\item{NA.x}{Set any values of 0 in \code{x} to \code{NA}}

\item{NA.y}{Set any values of 0 in \code{y} to \code{NA}}

\item{crosshairs}{is a logical value for the presence of crosshairs 
in all three orthogonal planes (default = TRUE).}

\item{col.crosshairs}{is the color of the crosshairs (default = red).}

\item{xlab}{is set to "" since all margins are set to zero.}

\item{ylab}{is set to "" since all margins are set to zero.}

\item{axes}{is set to FALSE since all margins are set to zero.}

\item{oma}{is the size of the outer margins in the par function.}

\item{mar}{is the number of lines of margin in the par function.}

\item{bg}{is the background color in the par function.}

\item{text}{allows the user to specify text to appear in 
the fourth (unused) pane.}

\item{text.color}{is the color of the user-specified text 
(default = ``white").}

\item{text.cex}{is the size of the user-specified text (default = 2).}

\item{text.x}{x coordinate for text}

\item{text.y}{y coordinate for text}

\item{add.orient}{(logical) Add left/right, A/P, etc. orientation}

\item{mfrow}{(numeric) layout of the 3 slices}

\item{ybreaks}{(numeric) breaks for y to passed to 
\code{\link[graphics]{image}}}

\item{breaks}{(numeric) breaks for x to passed to 
\code{\link[graphics]{image}}}

\item{addlegend}{(logical) add legend?}

\item{leg.x}{(numeric) x coordinate for legend}

\item{leg.y}{(numeric) y coordinate for legend}

\item{legend}{(character) legend text}

\item{leg.col}{(character) Colors for legend}

\item{leg.title}{(character) title for legend}

\item{leg.cex}{(numeric) \code{cex} for \code{\link{legend}}}

\item{window}{(vector) Length-2 vector to limit image to certain range}

\item{ycolorbar}{(logical) Should a colorbar for \code{y} be plotted}

\item{clabels}{Label for colorbar (see \code{\link{colorbar}})}

\item{add}{Should the y-plot be added or its own plot?  Used
in \code{double_ortho}}

\item{pdim}{Pixel dimensions if passing in arrays.  Will be overridden if 
\code{x} is a \code{nifti} object}

\item{useRaster}{logical; if TRUE a bitmap raster is used to 
plot the image instead of polygons.  Passed to 
\code{\link[graphics]{image}}.}

\item{mask}{If a mask is passed, \code{drop_empty_dim} is applied 
to both \code{x} and \code{y}}

\item{...}{other arguments to the image function may be provided here.}
}
\description{
Copy of \code{oro.nifti}'s \code{\link{orthographic}} function 
with some tweaks such as adding L/R designations for left and right
}
\examples{
set.seed(10)
x = oro.nifti::nifti(array(rnorm(1000), dim = rep(10, 3)))
ortho2(x)
y = x > 2
mask = x > 2.5
ortho2(x, y)
ortho2(x, y, mask = mask, add.orient = TRUE)
ortho2(x, y, mask = mask, add.orient = TRUE, add = FALSE)
nim = RNifti::asNifti(x, internal = FALSE)
ortho2(nim, y, mask = mask)
neurobase::ortho2(nim, x, mask = mask, 
ybreaks = seq(min(x), max(x), length.out = 65), ycolorbar = TRUE)

ortho2(nim, y, mask = mask, add = FALSE)
arr_x = as.array(x)
arr_y = as.array(y)
ortho2( arr_x)
ortho2( arr_x, arr_y, useRaster = FALSE)

set.seed(10)
x = oro.nifti::nifti(array(rnorm(10000), dim = rep(10, 4)))
y = x > 2
mask = x > 2.5
ortho2(x, y)

set.seed(10)
x = oro.nifti::nifti(array(rnorm(100), dim = rep(10, 2)))
y = x > 2
mask = x > 2.5
ortho2(x, y)
}
\seealso{
\link{orthographic}
}
