% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-attachment.R
\name{ns_get_submission_attachments}
\alias{ns_get_submission_attachments}
\title{Get Nettskjema attachments for a submission}
\usage{
ns_get_submission_attachments(
  submission_id,
  filenames = "standardized",
  output_dir = paste0("./", submission_id)
)
}
\arguments{
\item{submission_id}{integer. Unique identifier of a specific Nettskjema submission.}

\item{filenames}{Character of either 'standardized'
(default) or 'original' indicating which file names to use.}

\item{output_dir}{directory to output the files to}
}
\value{
a data.frame with information on attachments
  available, files written to path
}
\description{
Each unique submission ID in Nettskjema
may have some attachments. This function
saves all attachments associated with a
submission ID.
}
\examples{
\dontrun{
submission_id <- 22222
ns_get_submission_attachments(submission_id)
ns_get_submission_attachments(submission_id, "original")

}
}
