% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trauma_03.R
\name{trauma_03}
\alias{trauma_03}
\title{Trauma-03 Calculation}
\usage{
trauma_03(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  disposition_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  esituation_02_col,
  eresponse_05_col,
  edisposition_28_col,
  transport_disposition_col,
  evitals_01_col,
  evitals_27_col = NULL,
  evitals_27_initial_col = NULL,
  evitals_27_last_col = NULL,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing EMS data with all relevant
columns. Default is \code{NULL}.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data frame or tibble containing only the esituation
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{disposition_table}{A data frame or tibble containing only the
edisposition fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{vitals_table}{A data frame or tibble containing only the evitals fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{The column representing the EMS record unique
identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{The column for patient age numeric value.}

\item{epatient_16_col}{The column for patient age unit (e.g., "Years",
"Months").}

\item{esituation_02_col}{The column containing information on the presence of
injury.}

\item{eresponse_05_col}{The column representing the 911 response type.}

\item{edisposition_28_col}{The column for patient care disposition details.}

\item{transport_disposition_col}{The column for patient transport
disposition.}

\item{evitals_01_col}{The column for the time of pain scale measurement.}

\item{evitals_27_col}{The column for the full set of pain scale scores.}

\item{evitals_27_initial_col}{The column for the initial pain scale score.}

\item{evitals_27_last_col}{The column for the last pain scale score.}

\item{...}{Additional arguments passed to helper functions for further
customization.}
}
\value{
A tibble summarizing results for three population groups (All,
Adults, and Peds) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (All, Adults, Peds).
\code{numerator}: Count of incidents where there was a reduction in patient
pain.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of incidents where there was a reduction in patient
pain.
\code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
}
\description{
This function calculates the "Trauma-03" measure, which evaluates pain scale
reassessment for trauma patients, using a comprehensive data frame with EMS
records. The function processes input data to create both fact and dimension
tables, identifies eligible patients, and summarizes results for adult and
pediatric populations.
}
\examples{
# Synthetic test data
# for testing a single pain scale column
  test_data2 <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    esituation_02 = rep("Yes", 5),
    evitals_01 = lubridate::as_datetime(c("2025-01-01 12:00:00", "2025-01-05
    18:00:00", "2025-02-01 06:00:00", "2025-01-01 01:00:00", "2025-06-01
    14:00:00")),
    edisposition_28 = rep(4228001, 5),
    edisposition_30 = c(4230001, 4230003, 4230001, 4230007, 4230007)
  )

  # Expand data so each erecord_01 has 2 rows (one for each pain score)
  test_data_expanded2 <- test_data2 |>
    tidyr::uncount(weights = 2) |>  # Duplicate each row twice
    # Assign pain scores
    dplyr::mutate(evitals_27 = c(0, 0, 2, 1, 4, 3, 6, 5, 8, 7)) |>
    dplyr::group_by(erecord_01) |>
    dplyr::mutate(
    # Lower score = later time
      time_offset = dplyr::if_else(dplyr::row_number() == 1, -5, 0),
      evitals_01 = evitals_01 + lubridate::dminutes(time_offset)
    ) |>
    dplyr::ungroup() |>
    dplyr::select(-time_offset)  # Remove temporary column

# Run function with the single pain score column
  trauma_03(
    df = test_data_expanded2,
    erecord_01_col = erecord_01,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    esituation_02_col = esituation_02,
    evitals_01_col = evitals_01,
    evitals_27_initial_col = NULL,
    evitals_27_last_col = NULL,
    evitals_27_col = evitals_27,
    edisposition_28_col = edisposition_28,
    transport_disposition_col = edisposition_30
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
