% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StaPLR.R
\name{predict.StaPLRcoef}
\alias{predict.StaPLRcoef}
\title{Make predictions from a "StaPLRcoef" object.}
\usage{
\method{predict}{StaPLRcoef}(object, newx, view, newcf = NULL, predtype = "response", ...)
}
\arguments{
\item{object}{Extracted StaPLR coefficients as a "StaPLRcoef" object.}

\item{newx}{Matrix of new values for x at which predictions are to be made. Must be a matrix.}

\item{view}{a vector of length nvars, where each entry is an integer describing to which view each feature corresponds.}

\item{newcf}{Matrix of new values of correction features, if correct.for was specified during model fitting.}

\item{predtype}{The type of prediction returned by the meta-learner. Allowed values are "response", "link", and "class".}

\item{...}{Not currently used.}
}
\value{
A matrix of predictions.
}
\description{
Predict using a "StaPLRcoef" object. A "StaPLRcoef" object can be considerably smaller than a full "StaPLR" object for large data sets.
}
\examples{
\donttest{
set.seed(012)
n <- 1000
cors <- seq(0.1,0.7,0.1)
X <- matrix(NA, nrow=n, ncol=length(cors)+1)
X[,1] <- rnorm(n)

for(i in 1:length(cors)){
  X[,i+1] <- X[,1]*cors[i] + rnorm(n, 0, sqrt(1-cors[i]^2))
}

beta <- c(1,0,0,0,0,0,0,0)
eta <- X \%*\% beta
p <- exp(eta)/(1+exp(eta))
y <- rbinom(n, 1, p)
view_index <- rep(1:(ncol(X)/2), each=2)

fit <- StaPLR(X, y, view_index)
coefficients <- coef(fit)

new_X <- matrix(rnorm(16), nrow=2)
predict(coefficients, new_X, view_index)}
}
\author{
Wouter van Loon <w.s.van.loon@fsw.leidenuniv.nl>
}
\keyword{TBA}
