% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRM.R
\name{MRM}
\alias{MRM}
\alias{mrm}
\title{Minority Report Measure}
\usage{
MRM(fit, constant, level = 2, a = 0, b = 1, cvlambda = "lambda.min")

mrm(fit, constant, level = 2, a = 0, b = 1, cvlambda = "lambda.min")
}
\arguments{
\item{fit}{an object of class \code{\link[mvs]{MVS}}.}

\item{constant}{the value at which to keep the predictions of the other views constant. The recommended value is the mean of the outcome variable.}

\item{level}{the level at which to calculate the MRM. In a 3-level MVS model, \code{level = 2} (the default) is generally the level for which one would want to calculate the MRM. Note that calculating the MRM for \code{level = 1} (the feature level) is possible, but generally not sensible except under specific conditions.}

\item{a}{the start of the interval over which to calculate the MRM. Defaults to 0.}

\item{b}{the end of the interval over which to calculate the MRM. Defaults to 1.}

\item{cvlambda}{denotes which values of the penalty parameters to use for calculating predictions. This corresponds to the defaults used during model fitting.}
}
\value{
A numeric vector of a length equal to the number of views at the specified level, containing the values of the MRM for each view.
}
\description{
Calculate the Minority Report Measure (MRM) for each view in a (hierarchical) multi-view stacking model.
}
\details{
The Minority Report Measure (MRM) considers the view-specific sub-models at a given level of the hierarchy as members of a committee making predictions of the outcome variable. For each view, the MRM quantifies how much the final prediction of the stacked model changes if the prediction of the corresponding sub-model changes from \code{a} to \code{b}, while keeping the predictions corresponding to the other views constant at \code{constant}. For more information about the MRM see <doi:10.3389/fnins.2022.830630>.
}
\examples{
\donttest{ 
set.seed(012)
n <- 1000
X <- matrix(rnorm(8500), nrow=n, ncol=85)
beta <- c(rep(10, 55), rep(0, 30)) * ((rbinom(85, 1, 0.5)*2)-1)
eta <- X \%*\% beta
p <- 1 /(1 + exp(-eta))
y <- rbinom(n, 1, p)

## 3-level MVS
bottom_level <- c(rep(1:3, each=15), rep(4:5, each=10), rep(6:9, each=5))
top_level <- c(rep(1,45), rep(2,20), rep(3,20))
views <- cbind(bottom_level, top_level)
fit <- MVS(x=X, y=y, views=views, levels=3, alphas=c(0,1,1), nnc=c(0,1,1))
MRM(fit, constant=mean(y))
}
}
\author{
Wouter van Loon <w.s.van.loon@fsw.leidenuniv.nl>
}
\keyword{TBA}
