% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{dlogt}
\alias{dlogt}
\alias{plogt}
\alias{qlogt}
\title{Log Student's t distribution}
\usage{
dlogt(x, df, location = 0, scale = 1)

plogt(q, df, location = 0, scale = 1)

qlogt(p, df, location = 0, scale = 1)
}
\arguments{
\item{x, q}{Vector of quantiles}

\item{df}{Degrees of freedom, greater than zero}

\item{location}{Location parameter}

\item{scale}{Scale parameter, greater than zero}

\item{p}{Vector of probabilities}
}
\value{
\code{dlogt()} gives the density, \code{plogt()} gives the distribution
function, \code{qlogt()} gives the quantile function.
}
\description{
Density, distribution, and quantile function for the log t distribution,
whose logarithm has degrees of freedom \code{df}, mean \code{location}, and standard
deviation \code{scale}.
}
\details{
If \eqn{\log(Y) \sim t_\nu(\mu, \sigma^2)}, then \eqn{Y} has a log t
distribution with \code{location} \eqn{\mu}, \code{scale} \eqn{\sigma}, and \code{df}
\eqn{\nu}.

The mean and all higher moments of the log t distribution are undefined or
infinite.

If \code{df = 1} then the distribution is a log Cauchy distribution. As \code{df}
tends to infinity, this approaches a log Normal distribution.
}
