% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_summary-class.R
\name{nma_summary-class}
\alias{nma_summary-class}
\alias{nma_summary}
\alias{nma_rank_probs}
\title{The \code{nma_summary} class}
\description{
The \code{nma_summary} class contains posterior summary statistics of model
parameters or other quantities of interest, and the draws used to obtain
these statistics.
}
\details{
Objects of class \code{nma_summary} have the following components:
\describe{
\item{summary}{A data frame containing the computed summary statistics. If
a regression model was fitted with effect modifier interactions with
treatment, these summaries will be study-specific. In this case, the
corresponding study population is indicated in a column named \code{.study}.}
\item{sims}{A 3D array [Iteration, Chain, Parameter] of MCMC
simulations}
\item{studies}{(Optional) A data frame containing study information,
printed along with the corresponding summary statistics if \code{summary}
contains a \code{.study} column. Should have a matching \code{.study} column.}
}

The following attributes may also be set:
\describe{
\item{xlab}{Label for x axis in plots, usually either \code{"Treatment"} or
\code{"Contrast"}.}
\item{ylab}{Label for y axis in plots, usually used for the scale e.g.
\code{"log Odds Ratio"}.}
}

The subclass \code{nma_rank_probs} is used by the function
\code{\link[=posterior_rank_probs]{posterior_rank_probs()}}, and contains posterior rank probabilities. This
subclass does not have a \code{sims} component, as the rank probabilities are
themselves posterior summaries of the ranks (i.e. they do not have a
posterior distribution). The posterior ranks from which the rank
probabilities are calculated may be obtained from \code{\link[=posterior_ranks]{posterior_ranks()}}.
}
