% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_summary-class.R
\name{plot.nma_summary}
\alias{plot.nma_summary}
\alias{plot.nma_parameter_summary}
\alias{plot.nma_rank_probs}
\title{Plots of summary results}
\usage{
\method{plot}{nma_summary}(
  x,
  ...,
  stat = "pointinterval",
  orientation = c("horizontal", "vertical", "y", "x"),
  ref_line = NA_real_
)

\method{plot}{nma_parameter_summary}(
  x,
  ...,
  stat = "pointinterval",
  orientation = c("horizontal", "vertical", "y", "x"),
  ref_line = NA_real_
)

\method{plot}{nma_rank_probs}(x, ...)
}
\arguments{
\item{x}{A \code{nma_summary} object}

\item{...}{Additional arguments passed on to the underlying \code{ggdist} plot
stat, see Details}

\item{stat}{Character string specifying the \code{ggdist} plot stat to use,
default \code{"pointinterval"}}

\item{orientation}{Whether the \code{ggdist} geom is drawn horizontally
(\code{"horizontal"}) or vertically (\code{"vertical"}), default \code{"horizontal"}}

\item{ref_line}{Numeric vector of positions for reference lines, by default
no reference lines are drawn}
}
\value{
A \code{ggplot} object.
}
\description{
The \code{plot} method for \code{nma_summary} objects is used to produce plots of
parameter estimates (when called on a \code{stan_nma} object or its summary),
relative effects (when called on the output of \code{\link[=relative_effects]{relative_effects()}}),
absolute predictions (when called on the output of \code{\link[=predict.stan_nma]{predict.stan_nma()}}),
posterior ranks and rank probabilities (when called on the output of
\code{\link[=posterior_ranks]{posterior_ranks()}} or \code{\link[=posterior_rank_probs]{posterior_rank_probs()}}).
}
\details{
Plotting is handled by \link{ggplot2} and the stats and geoms provided in
the \link{ggdist} package. As a result, the output is very flexible. Any
plotting stats provided by \code{ggdist} may be used, via the argument
\code{stat}. The default uses
\code{\link[ggdist:stat_pointinterval]{ggdist::stat_pointinterval()}}, to
produce medians and 95\% Credible Intervals with 66\% inner bands.
Additional arguments in \code{...} are passed to the \code{ggdist} stat, to
customise the output. For example, to produce means and Credible Intervals,
specify \code{point_interval = mean_qi}. To produce an 80\% Credible Interval
with no inner band, specify \code{.width = c(0, 0.8)}.

Alternative stats can be specified to produce different summaries. For
example, specify \code{stat = "[half]eye"} to produce (half) eye plots, or \code{stat = "histinterval"} to produce histograms with intervals.

A full list of options and examples is found in the \code{ggdist} vignette
\code{vignette("slabinterval", package = "ggdist")}.

A \code{ggplot} object is returned which can be further modified through the
usual \link{ggplot2} functions to add further aesthetics, geoms, themes, etc.
}
\examples{
## Smoking cessation
# Set up network of smoking cessation data
head(smoking)

smk_net <- set_agd_arm(smoking,
                       study = studyn,
                       trt = trtc,
                       r = r,
                       n = n,
                       trt_ref = "No intervention")

# Print details
smk_net

\donttest{
# Fitting a random effects model
smk_fit_RE <- nma(smk_net,
                  trt_effects = "random",
                  prior_intercept = normal(scale = 100),
                  prior_trt = normal(scale = 100),
                  prior_het = normal(scale = 5))

smk_fit_RE
}

\donttest{
# Produce relative effects
smk_releff_RE <- relative_effects(smk_fit_RE)
plot(smk_releff_RE, ref_line = 0)

# Customise plot options
plot(smk_releff_RE, ref_line = 0, stat = "halfeye")

# Further customisation is possible with ggplot commands
plot(smk_releff_RE, ref_line = 0, stat = "halfeye", slab_alpha = 0.6) +
  ggplot2::aes(slab_fill = ifelse(..x.. < 0, "darkred", "grey60"))

# Produce posterior ranks
smk_rank_RE <- posterior_ranks(smk_fit_RE, lower_better = FALSE)
plot(smk_rank_RE)

# Produce rank probabilities
smk_rankprob_RE <- posterior_rank_probs(smk_fit_RE, lower_better = FALSE)
plot(smk_rankprob_RE)

# Produce cumulative rank probabilities
smk_cumrankprob_RE <- posterior_rank_probs(smk_fit_RE, lower_better = FALSE,
                                           cumulative = TRUE)
plot(smk_cumrankprob_RE)

#' # Further customisation is possible with ggplot commands
plot(smk_cumrankprob_RE) +
  ggplot2::facet_null() +
  ggplot2::aes(colour = Treatment)
}
}
