% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_multinom_uc_omc_sel.R
\name{adjust_multinom_uc_omc_sel}
\alias{adjust_multinom_uc_omc_sel}
\title{Adust for uncontrolled confounding, outcome misclassification, and selection
bias.}
\usage{
adjust_multinom_uc_omc_sel(
  data,
  exposure,
  outcome,
  confounders = NULL,
  u0y1_model_coefs,
  u1y0_model_coefs,
  u1y1_model_coefs,
  s_model_coefs,
  level = 0.95
)
}
\arguments{
\item{data}{Dataframe for analysis.}

\item{exposure}{String name of the exposure variable.}

\item{outcome}{String name of the outcome variable.}

\item{confounders}{String name(s) of the confounder(s).
A maximum of three confounders are allowed.}

\item{u0y1_model_coefs}{The regression coefficients corresponding to the
model:
\ifelse{html}{\out{log(P(U=0,Y=1)/P(U=0,Y=0)) = &gamma;<sub>2,0</sub> + &gamma;<sub>2,1</sub>X + &gamma;<sub>2,2</sub>Y* + &gamma;<sub>2,2+j</sub>C<sub>j</sub>, }}{\eqn{log(P(U=0,Y=1)/P(U=0,Y=0)) = \gamma_{2,0} + \gamma_{2,1} X + \gamma_{2,2} Y^* + \gamma_{2,2+j} C_j, }}
where U is the binary unmeasured confounder, Y is the binary true outcome,
X is the binary exposure, Y* is the binary misclassified outcome, C
represents the vector of binary measured confounders (if any), and
j corresponds to the number of measured confounders.}

\item{u1y0_model_coefs}{The regression coefficients corresponding to the
model:
\ifelse{html}{\out{log(P(U=1,Y=0)/P(U=0,Y=0)) = &gamma;<sub>1,0</sub> + &gamma;<sub>1,1</sub>X + &gamma;<sub>1,2</sub>Y* + &gamma;<sub>1,2+j</sub>C<sub>j</sub>, }}{\eqn{log(P(U=1,Y=0)/P(U=0,Y=0)) = \gamma_{1,0} + \gamma_{1,1} X + \gamma_{1,2} Y^* + \gamma_{1,2+j} C_j, }}
where U is the binary unmeasured confounder, Y is the binary true outcome,
X is the binary exposure, Y* is the binary misclassified outcome, C
represents the vector of binary measured confounders (if any), and
j corresponds to the number of measured confounders.}

\item{u1y1_model_coefs}{The regression coefficients corresponding to the
model:
\ifelse{html}{\out{log(P(U=1,Y=1)/P(U=0,Y=0)) = &gamma;<sub>3,0</sub> + &gamma;<sub>3,1</sub>X + &gamma;<sub>3,2</sub>Y* + &gamma;<sub>3,2+j</sub>C<sub>j</sub>, }}{\eqn{log(P(U=1,Y=1)/P(U=0,Y=0)) = \gamma_{3,0} + \gamma_{3,1} X + \gamma_{3,2} Y^* + \gamma_{3,2+j} C_j, }}
where U is the binary unmeasured confounder, Y is the binary true outcome,
X is the binary exposure, Y* is the binary misclassified outcome, C
represents the vector of binary measured confounders (if any), and
j corresponds to the number of measured confounders.}

\item{s_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(S=1)) = &beta;<sub>0</sub> + &beta;<sub>1</sub>X + &beta;<sub>2</sub>Y* + &beta;<sub>2+j</sub>C<sub>j</sub>, }}{\eqn{logit(P(S=1)) = \beta_0 + \beta_1 X + \beta_2 Y^* + \beta_{2+j} C_j, }}
where S represents binary selection,
X is the binary exposure, Y* is the binary misclassified outcome,
C represents the vector of binary measured confounders (if any), and
j corresponds to the number of measured confounders.}

\item{level}{Value from 0-1 representing the full range of the confidence
interval. Default is 0.95.}
}
\value{
A list where the first item is the odds ratio estimate of the
 effect of the exposure on the outcome and the second item is the
 confidence interval as the vector: (lower bound, upper bound).
}
\description{
\code{adjust_multinom_uc_omc_sel} returns the exposure-outcome odds ratio and
confidence interval, adjusted for uncontrolled confounding, outcome
misclassificaiton, and selection bias.
}
\details{
This function uses one bias model, a multinomial logistic regression model,
to predict the uncontrolled confounder (U) and outcome (Y). If separate bias
models for U and Y are desired, use \code{adjust_uc_omc_sel}.

Values for the regression coefficients can be applied as
fixed values or as single draws from a probability
distribution (ex: \code{rnorm(1, mean = 2, sd = 1)}). The latter has
the advantage of allowing the researcher to capture the uncertainty
in the bias parameter estimates. To incorporate this uncertainty in the
estimate and confidence interval, this function should be run in loop across
bootstrap samples of the dataframe for analysis. The estimate and
confidence interval would then be obtained from the median and quantiles
of the distribution of odds ratio estimates.
}
\examples{
adjust_multinom_uc_omc_sel(
  df_uc_omc_sel,
  exposure = "X",
  outcome = "Ystar",
  confounders = c("C1", "C2", "C3"),
  u1y0_model_coefs = c(-0.20, 0.62, 0.01, -0.08, 0.10, -0.15),
  u0y1_model_coefs = c(-3.28, 0.63, 1.65, 0.42, -0.85, 0.26),
  u1y1_model_coefs = c(-2.70, 1.22, 1.64, 0.32, -0.77, 0.09),
  s_model_coefs = c(0.00, 0.74, 0.19, 0.02, -0.06, 0.02)
)

}
