% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traitMedusaSummary.R
\name{traitMedusaSummary}
\alias{traitMedusaSummary}
\title{Identify shifts in the rate of trait diversification}
\usage{
traitMedusaSummary(traitMedusaObject = NULL, cutoff = 4, AICc = TRUE,
  lowerBound = 1e-08, upperBound = 200, print.warnings = FALSE)
}
\arguments{
\item{traitMedusaObject}{Output of a medusa analysis in \code{\link{transformPhylo.ML}}}

\item{cutoff}{Cutoff value for differences in AIC scores when comparing models. More complex models with an AIC score more than this number of units lower than simpler models are retained (as per runMedusa in the \pkg{geiger}).}

\item{AICc}{If true, AICc is used instead of AIC.}

\item{lowerBound}{Minimum value for parameter estimates.}

\item{upperBound}{Maximum value for parameter estimates.}

\item{print.warnings}{Logical. If TRUE, warnings are issued if confidence intervals fall outside upper or lower bounds.}
}
\value{
ModelFit Summary of the best optimal rate shift model.

Rates Summary of the rate parameters from the best rate shift model.

optimalTree A phylo object with branch lengths scaled relative to rate.
}
\description{
Summarises phenotypic rate variation on phylogenies.
}
\details{
This functions summarises the output of a "medusa" model in transformPhylo.ML (see below). The best overall model is chosen based on AIC (or AICc if AICc=TRUE). The cut-off point for improvement in AIC score between successively more complex models can be defined using cutoff. The default cutoff is 4 but this is somewhat arbitrary and a "good" cut-off may well vary between data sets so it may well be worth exploring different cutoffs.
}
\examples{
data(anolis.tree)
data(anolis.data)
attach(anolis.data)
male.length <- matrix(Male_SVL, dimnames=list(rownames(anolis.data)))
sortedData <- sortTraitData(anolis.tree, male.length)
phy <- sortedData$phy
male.length <- sortedData$trait
phy.clade <- extract.clade(phy, 182)
male.length.clade <- as.matrix(male.length[match(phy.clade$tip.label, rownames(male.length)),])
tm1 <- transformPhylo.ML(male.length.clade, phy=phy.clade, model="tm1", minCladeSize=10, nSplits=1)
tm1_out <- traitMedusaSummary(tm1, cutoff=1)
}
\references{
Alfaro ME, Santini F, Brock CD, Alamillo H, Dornburg A, Carnevale G, Rabosky D & Harmon LJ. 2009. Nine exceptional radiations plus high turnover explain species diversity in jawed vertebrates. PNAS 106, 13410-13414.
O'Meara BC, Ane C, Sanderson MJ & Wainwright PC. 2006. Testing for different rates of continuous trait evolution using likelihood. Evolution 60, 922-933
Thomas GH, Meiri S, & Phillimore AB. 2009. Body size diversification in Anolis: novel environments and island effects. Evolution 63, 2017-2030.
}
\seealso{
\code{\link{transformPhylo.ML}}
}
\author{
Gavin Thomas
}
