% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morphomapRegradius.R
\name{morphomapRegradius}
\alias{morphomapRegradius}
\title{morphomapRegradius}
\usage{
morphomapRegradius(mat, center, n)
}
\arguments{
\item{mat}{a kx2 matrix}

\item{center}{coordinates of the center from which the calculation of regular radius started}

\item{n}{number of points}
}
\value{
V2 position of landmarks equi angular spaced
}
\description{
Wrapper of the function regularradius written by Julien Claude (Morphometrics with R)
}
\examples{
extsec<-morphomapCircle(10,1000)
sel<-morphomapRegradius(extsec,center = c(0,0),n=11)
selcoo<-extsec[sel,]
plot(extsec,type="l",asp=1)
points(selcoo,col="red",pch=19)
}
\references{
Claude, J. (2008). Morphometrics with R. Springer Science & Business Media.
}
\author{
Julien Claude, Antonio Profico
}
