% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simObsData.R
\name{simObsData}
\alias{simObsData}
\title{Observation error simulation tool}
\usage{
simObsData(data, lambda, errorEllipse)
}
\arguments{
\item{data}{A \code{\link{momentuHMMData}} object with necessary field 'x' (easting/longitudinal coordinates) and 'y' (northing/latitudinal coordinates)}

\item{lambda}{Observation rate for location data. If \code{NULL}, location data are kept at temporally-regular intervals. Otherwise 
\code{lambda} is the rate parameter of the exponential distribution for the waiting times between successive location observations, i.e., 
\code{1/lambda} is the expected time between successive location observations. Only the 'step' and 'angle' data streams are subject to temporal irregularity;
any other data streams are kept at temporally-regular intervals.  Ignored unless a valid distribution for the 'step' data stream is specified.}

\item{errorEllipse}{List providing the bounds for the semi-major axis (\code{M}; on scale of x- and y-coordinates), semi-minor axis (\code{m}; 
on scale of x- and y-coordinates), and orientation (\code{r}; in degrees) of location error ellipses. If \code{NULL}, no location 
measurement error is simulated. If \code{errorEllipse} is specified, then each observed location is subject to bivariate normal errors as described 
in McClintock et al. (2015), where the components of the error ellipse for each location are randomly drawn from \code{runif(1,min(errorEllipse$M),max(errorEllipse$M))}, 
\code{runif(1,min(errorEllipse$m),max(errorEllipse$m))}, and \code{runif(1,min(errorEllipse$r),max(errorEllipse$r))}. If only a single value is provided for any of the 
error ellipse elements, then the corresponding component is fixed to this value for each location. Only the 'step' and 'angle' data streams are subject to location measurement error;
any other data streams are observed without error.  Ignored unless a valid distribution for the 'step' data stream is specified.}
}
\value{
A dataframe of:
\item{time}{Numeric time of each observed (and missing) observation}
\item{ID}{The ID(s) of the observed animal(s)}
\item{x}{Either easting or longitude observed location}
\item{y}{Either norting or latitude observed location}
\item{...}{Data streams that are not derived from location (if applicable)}
\item{...}{Covariates at temporally-regular true (\code{mux},\code{muy}) locations (if any)}
\item{mux}{Either easting or longitude true location}
\item{muy}{Either norting or latitude true location}
\item{error_semimajor_axis}{error ellipse semi-major axis (if applicable)}
\item{error_semiminor_axis}{error ellipse semi-minor axis (if applicable)}
\item{error_ellipse_orientation}{error ellipse orientation (if applicable)}
\item{ln.sd.x}{log of the square root of the x-variance of bivariate normal error (if applicable; required for error ellipse models in \code{\link{crawlWrap}})}
\item{ln.sd.y}{log of the square root of the y-variance of bivariate normal error (if applicable; required for error ellipse models in \code{\link{crawlWrap}})}
\item{error.corr}{correlation term of bivariate normal error (if applicable; required for error ellipse models in \code{\link{crawlWrap}})}
}
\description{
Simulates observed location data subject to temporal irregularity and/or location measurement error
}
\details{
Simulated location data that are temporally-irregular (i.e., \code{lambda>0}) and/or with location measurement error (i.e., \code{errorEllipse!=NULL}) are returned
as a data frame suitable for analysis using \code{\link{crawlWrap}}.
}
\examples{
# extract momentuHMMData example
data <- example$m$data
lambda <- 2 # expect 2 observations per time step
errorEllipse <- list(M=c(0,50),m=c(0,50),r=c(0,180))
obsData1 <- simObsData(data,lambda=lambda,errorEllipse=errorEllipse)

errorEllipse <- list(M=50,m=50,r=180)
obsData2 <- simObsData(data,lambda=lambda,errorEllipse=errorEllipse)

}
\references{
McClintock BT, London JM, Cameron MF, Boveng PL. 2015. Modelling animal movement using the Argos satellite telemetry location error ellipse. 
Methods in Ecology and Evolution 6(3):266-277.
}
\seealso{
\code{\link{crawlWrap}}, \code{\link{prepData}}, \code{\link{simData}}
}
