% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_fit.R
\name{compare_fit}
\alias{compare_fit}
\title{compare model fit for \code{modsem} models}
\usage{
compare_fit(est_h1, est_h0, ...)
}
\arguments{
\item{est_h1}{object of class \code{\link{modsem_da}} or \code{\link{modsem_pi}} representing the
alternative hypothesis model (with interaction terms).}

\item{est_h0}{object of class \code{\link{modsem_da}} or \code{\link{modsem_pi}} representing the
null hypothesis model (without interaction terms).}

\item{...}{additional arguments passed to the underlying comparison function. E.g., 
for \code{modsem_pi} models, this can be used to pass arguments to \code{lavaan::lavTestLRT}.
currently only used for \code{modsem_pi} models.}
}
\description{
Compare the fit of two models using the likelihood ratio test (LRT).
hypothesis model, and \code{est_h1} the alternative hypothesis model. Importantly,
the function assumes that \code{est_h0} does not have more free parameters
(i.e., degrees of freedom) than \code{est_h1}.
alternative hypothesis model
}
\examples{
\dontrun{
m1 <- "
 # Outer Model
 X =~ x1 + x2 + x3
 Y =~ y1 + y2 + y3
 Z =~ z1 + z2 + z3

 # Inner model
 Y ~ X + Z + X:Z
"

# LMS approach
est_h1 <- modsem(m1, oneInt, "lms")
est_h0 <- estimate_h0(est_h1, calc.se=FALSE) # std.errors are not needed
compare_fit(est_h1 = est_h1, est_h0 = est_h0)

# Double centering approach
est_h1 <- modsem(m1, oneInt, method = "dblcent")
est_h0 <- estimate_h0(est_h1, oneInt)

compare_fit(est_h1 = est_h1, est_h0 = est_h0)

# Constrained approach
est_h1 <- modsem(m1, oneInt, method = "ca")
est_h0 <- estimate_h0(est_h1, oneInt)

compare_fit(est_h1 = est_h1, est_h0 = est_h0)
}
}
