test_that("model cards", {
  skip_on_cran()
  skip("Only tested locally")
  tmp = tempdir()
  tmp = paste0(tmp, "/report")
  unlink(tmp, recursive = TRUE)
  use_modelcard(tmp, edit = FALSE)
  expect_true(all(list.files(tmp) %in% c("references.bib", "style.css", paste0(basename(tmp), ".Rmd"), "LICENSE")))
  out = rmarkdown::render(paste0(tmp, "/", basename(tmp),  ".Rmd"))
  system(paste0("firefox ", out))
  expect_character(out)
  expect_true(readLines(out)[1] == "<!DOCTYPE html>")
  unlink(tmp, recursive = TRUE)
})

test_that("datasheets", {
  skip_on_cran()
  skip("Only tested locally")
  tmp = tempdir()
  tmp = paste0(tmp, "/report")
  unlink(tmp, recursive = TRUE)
  use_datasheet(tmp, edit = FALSE)
  expect_true(all(list.files(tmp) %in% c("references.bib", "style.css", paste0(basename(tmp), ".Rmd"), "LICENSE")))
  out = rmarkdown::render(paste0(tmp, "/", basename(tmp),  ".Rmd"))
  expect_character(out)
  expect_true(readLines(out)[1] == "<!DOCTYPE html>")
  unlink(tmp, recursive = TRUE)
})

test_that("fairness_report", {
  skip_on_cran()
  skip("Only tested locally")
  tmp = tempdir()
  tmp = paste0(tmp, "/report")
  unlink(tmp, recursive = TRUE)
  task = tsk("compas")
  learner = lrn("classif.rpart", predict_type = "prob")
  rr = resample(task, learner, rsmp("cv", folds = 5))
  report_fairness(tmp, list(task = task, resampling_result = rr))
  expect_true(all(c("references.bib", paste0(basename(tmp), ".Rmd")) %in% list.files(tmp)))
  out = rmarkdown::render(paste0(tmp, "/", basename(tmp),  ".Rmd"))
  expect_character(out)
  expect_true(readLines(out)[1] == "<!DOCTYPE html>")
  unlink(tmp, recursive = TRUE)
})
