% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{gseq.revcomp}
\alias{gseq.revcomp}
\title{Get reverse complement of DNA sequence}
\usage{
gseq.revcomp(seq)
}
\arguments{
\item{seq}{A character vector containing DNA sequences (using A,C,G,T). Ignores other characters and NA values.}
}
\value{
A character vector of the same length as the input, containing the reverse
        complement sequences
}
\description{
Alias for \code{\link{grevcomp}}. Takes a DNA sequence string and returns its reverse complement.
}
\examples{
gseq.revcomp("ACTG") # Returns "CAGT"
gseq.revcomp(c("ACTG", "GGCC")) # Returns c("CAGT", "GGCC")

}
\seealso{
\code{\link{grevcomp}}, \code{\link{gseq.rev}}, \code{\link{gseq.comp}}
}
