% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-operations.R
\name{gintervals.force_range}
\alias{gintervals.force_range}
\title{Limits intervals to chromosomal range}
\usage{
gintervals.force_range(intervals = NULL, intervals.set.out = NULL)
}
\arguments{
\item{intervals}{intervals}

\item{intervals.set.out}{intervals set name where the function result is
optionally outputted}
}
\value{
If 'intervals.set.out' is 'NULL' a data frame representing the
intervals.
}
\description{
Limits intervals to chromosomal range.
}
\details{
This function enforces the intervals to be within the chromosomal range [0,
chrom length) by altering the intervals' boundaries. Intervals that lay
entirely outside of the chromosomal range are eliminated. The new intervals
are returned.

If 'intervals.set.out' is not 'NULL' the result is saved as an intervals
set. Use this parameter if the result size exceeds the limits of the
physical memory.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
intervs <- data.frame(
    chrom = "chr1",
    start = c(11000, -100, 10000, 10500),
    end = c(12000, 200, 13000000, 10600)
)
gintervals.force_range(intervs)

}
\seealso{
\code{\link{gintervals}}, \code{\link{gintervals.2d}},
\code{\link{gintervals.canonic}}
}
\keyword{~intervals}
