% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-distribution.R
\name{gdist}
\alias{gdist}
\title{Calculates distribution of track expressions}
\usage{
gdist(
  ...,
  intervals = NULL,
  include.lowest = FALSE,
  iterator = NULL,
  band = NULL
)
}
\arguments{
\item{...}{pairs of 'expr', 'breaks' where 'expr' is a track expression and the breaks determine the bin}

\item{intervals}{genomic scope for which the function is applied}

\item{include.lowest}{if 'TRUE', the lowest value of the range determined by
breaks is included}

\item{iterator}{track expression iterator. If 'NULL' iterator is determined
implicitly based on track expressions.}

\item{band}{track expression band. If 'NULL' no band is used.}
}
\value{
N-dimensional vector where N is the number of 'expr'-'breaks' pairs.
}
\description{
Calculates distribution of track expressions' values over the given set of
bins.
}
\details{
This function calculates the distribution of values of the numeric track
expressions over the given set of bins.

The range of bins is determined by 'breaks' argument. For example:
'breaks=c(x1, x2, x3, x4)' represents three different intervals (bins): (x1,
x2], (x2, x3], (x3, x4].

If 'include.lowest' is 'TRUE' the the lowest value will be included in the
first interval, i.e. in [x1, x2]

'gdist' can work with any number of dimensions. If more than one
'expr'-'breaks' pair is passed, the result is a multidimensional vector, and
an individual value can be accessed by [i1,i2,...,iN] notation, where 'i1'
is the first track and 'iN' is the last track expression.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()

## calculate the distribution of dense_track for bins:
## (0, 0.2], (0.2, 0.5] and (0.5, 1]
gdist("dense_track", c(0, 0.2, 0.5, 1))

## calculate two-dimensional distribution:
## dense_track vs. sparse_track
gdist("dense_track", seq(0, 1, by = 0.1), "sparse_track",
    seq(0, 2, by = 0.2),
    iterator = 100
)

}
\seealso{
\code{\link{gextract}}
}
\keyword{~distribution}
