% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{gtrack.lookup}
\alias{gtrack.lookup}
\title{Creates a new track from a lookup table based on track expression}
\usage{
gtrack.lookup(
  track = NULL,
  description = NULL,
  lookup_table = NULL,
  ...,
  include.lowest = FALSE,
  force.binning = TRUE,
  iterator = NULL,
  band = NULL
)
}
\arguments{
\item{track}{track name}

\item{description}{a character string description}

\item{lookup_table}{a multi-dimensional array containing the values that are
returned by the function}

\item{...}{pairs of track expressions and breaks}

\item{include.lowest}{if 'TRUE', the lowest value of the range determined by
breaks is included}

\item{force.binning}{if 'TRUE', the values smaller than the minimal break
will be translated to index 1, and the values that exceed the maximal break
will be translated to index N-1 where N is the number of breaks. If 'FALSE'
the out-of-range values will produce NaN values.}

\item{iterator}{track expression iterator. If 'NULL' iterator is determined
implicitly based on track expressions.}

\item{band}{track expression band. If 'NULL' no band is used.}
}
\value{
None.
}
\description{
Evaluates track expression and translates the values into bin indices that
are used in turn to retrieve values from a lookup table and create a track.
}
\details{
This function evaluates the track expression for all iterator intervals and
translates this value into an index based on the breaks. This index is then
used to address the lookup table and create with its values a new track.
More than one 'expr'-'breaks' pair can be used. In that case 'lookup_table'
is addressed in a multidimensional manner, i.e. 'lookup_table[i1, i2, ...]'.

The range of bins is determined by 'breaks' argument. For example: 'breaks =
c(x1, x2, x3, x4)' represents three different intervals (bins): (x1, x2],
(x2, x3], (x3, x4].

If 'include.lowest' is 'TRUE' the the lowest value is included in the first
interval, i.e. in [x1, x2].

'force.binning' parameter controls what should be done when the value of
'expr' exceeds the range determined by 'breaks'. If 'force.binning' is
'TRUE' then values smaller than the minimal break will be translated to
index 1, and the values exceeding the maximal break will be translated to
index 'M-1' where 'M' is the number of breaks. If 'force.binning' is 'FALSE'
the out-of-range values will produce 'NaN' values.

Regardless of 'force.binning' value if the value of 'expr' is 'NaN' then the
value in the track would be 'NaN' too.

'description' is added as a track attribute.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()

## one-dimensional example
breaks1 <- seq(0.1, 0.2, length.out = 6)
gtrack.lookup(
    "lookup_track", "Test track", 1:5, "dense_track",
    breaks1
)
gtrack.rm("lookup_track", force = TRUE)

## two-dimensional example
t <- array(1:15, dim = c(5, 3))
breaks2 <- seq(0.31, 0.37, length.out = 4)
gtrack.lookup(
    "lookup_track", "Test track", t, "dense_track",
    breaks1, "2 * dense_track", breaks2
)
gtrack.rm("lookup_track", force = TRUE)

}
\seealso{
\code{\link{glookup}}, \code{\link{gtrack.2d.create}},
\code{\link{gtrack.create_sparse}}, \code{\link{gtrack.smooth}},
\code{\link{gtrack.modify}}, \code{\link{gtrack.rm}},
\code{\link{gtrack.info}}, \code{\link{gdir.create}}
}
\keyword{~lookup}
\keyword{~track}
