% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{gtrack.create_dense}
\alias{gtrack.create_dense}
\title{Creates a 'Dense' track from intervals and values}
\usage{
gtrack.create_dense(
  track = NULL,
  description = NULL,
  intervals = NULL,
  values = NULL,
  binsize = NULL,
  defval = NaN
)
}
\arguments{
\item{track}{track name}

\item{description}{a character string description}

\item{intervals}{a set of one-dimensional intervals}

\item{values}{an array of numeric values - one for each interval}

\item{binsize}{bin size of the newly created 'Dense' track}

\item{defval}{default track value for genomic regions not covered by the intervals}
}
\value{
None.
}
\description{
Creates a 'Dense' track from intervals and values.
}
\details{
This function creates a new 'Dense' track with values at given intervals.
'description' is added as a track attribute.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
intervs <- gintervals.load("annotations")
gtrack.create_dense(
    "test_dense", "Test dense track", intervs,
    1:dim(intervs)[1], 50, 0
)
gextract("test_dense", .misha$ALLGENOME)
gtrack.rm("test_dense", force = TRUE)

}
\seealso{
\code{\link{gtrack.create_sparse}}, \code{\link{gtrack.import}},
\code{\link{gtrack.modify}}, \code{\link{gtrack.rm}},
\code{\link{gtrack.info}}
}
\keyword{~create}
\keyword{~dense}
\keyword{~track}
