% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{fit.gev}
\alias{fit.gev}
\title{Maximum likelihood estimation for the generalized extreme value distribution}
\usage{
fit.gev(
  xdat,
  start = NULL,
  method = c("nlminb", "BFGS"),
  show = FALSE,
  fpar = NULL,
  warnSE = FALSE
)
}
\arguments{
\item{xdat}{a numeric vector of data to be fitted.}

\item{start}{named list of starting values}

\item{method}{string indicating the outer optimization routine for the augmented Lagrangian. One of \code{nlminb} or \code{BFGS}.}

\item{show}{logical; if \code{TRUE} (the default), print details of the fit.}

\item{fpar}{a named list with optional fixed components \code{loc}, \code{scale} and \code{shape}}

\item{warnSE}{logical; if \code{TRUE}, a warning is printed if the standard errors cannot be returned from the observed information matrix when the shape is less than -0.5.}
}
\value{
a list containing the following components:
\itemize{
\item \code{estimate} a vector containing the maximum likelihood estimates.
\item \code{std.err} a vector containing the standard errors.
\item \code{vcov} the variance covariance matrix, obtained as the numerical inverse of the observed information matrix.
\item \code{method} the method used to fit the parameter.
\item \code{nllh} the negative log-likelihood evaluated at the parameter \code{estimate}.
\item \code{convergence} components taken from the list returned by \code{\link[alabama]{auglag}}.
Values other than \code{0} indicate that the algorithm likely did not converge.
\item \code{counts} components taken from the list returned by \code{\link[alabama]{auglag}}.
\item \code{xdat} vector of data
}
}
\description{
This function returns an object of class \code{mev_gev}, with default methods for printing and quantile-quantile plots.
The default starting values are the solution of the probability weighted moments.
}
\examples{
xdat <- mev::rgev(n = 100)
fit.gev(xdat, show = TRUE)
# Example with fixed parameter
fit.gev(xdat, show = TRUE, fpar = list(shape = 0))
}
