% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box.R
\name{boxplot.data.frame}
\alias{boxplot.data.frame}
\title{Boxplot Method for Data Frame}
\usage{
\method{boxplot}{data.frame}(x, ..., fun = getOption("metaplot_box",
  "boxplot_data_frame"))
}
\arguments{
\item{x}{data.frame}

\item{...}{passed to fun}

\item{fun}{function that does the actual plotting}
}
\description{
Boxplot for data.frame.  Parses arguments and generates the call: fun(x, yvar, xvar, facets, ...).
}
\examples{
library(dplyr)
library(magrittr)
Theoph \%<>\% mutate(site = ifelse(as.numeric(Subject) > 6, 'Site A','Site B'))
boxplot(Theoph,'Subject','conc')
boxplot(Theoph,Subject,conc)
boxplot(Theoph,conc,Subject)
boxplot(Theoph,conc,Subject,site)
attr(Theoph,'title') <- 'Theophylline'
boxplot(Theoph, Subject, conc, main = function(x,...)attr(x,'title'))
boxplot(Theoph, Subject, conc, sub= function(x,...)attr(x,'title'))
}
\seealso{
Other mixedvariate plots: \code{\link{boxplot_data_frame}},
  \code{\link{boxplot_panel}}

Other boxplot: \code{\link{boxplot_data_frame}}

Other methods: \code{\link{axislabel.data.frame}},
  \code{\link{categorical.data.frame}},
  \code{\link{corsplom.data.frame}},
  \code{\link{densplot.data.frame}},
  \code{\link{metaplot.data.frame}},
  \code{\link{pack.data.frame}},
  \code{\link{scatter.data.frame}},
  \code{\link{unpack.data.frame}}
}
