% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputes.R
\name{impute_bpca}
\alias{impute_bpca}
\title{Impute missing values using Bayesian PCA}
\usage{
impute_bpca(data, n_pcs = 2, center = TRUE, scale = "none", direction = 2)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{n_pcs}{The number of PCs to calculate.}

\item{center}{Should \code{data} be mean centered? See \code{\link[pcaMethods]{prep}} for details.}

\item{scale}{Should \code{data} be scaled? See \code{\link[pcaMethods]{prep}} for details.}

\item{direction}{Either \code{1} or \code{2}. \code{1} runs a PCA on a matrix with samples in columns and features in rows and \code{2} runs a PCA on a matrix with features in columns and samples in rows.
Both are valid according to this \href{https://github.com/hredestig/pcaMethods/issues/25}{discussion on GitHub} but give \strong{different results}.}
}
\value{
A tibble with imputed missing values.
}
\description{
One of several PCA-based imputation methods. Basically a wrapper around \verb{pcaMethods::}\code{\link[pcaMethods]{pca}}\code{(method = "bpca")}.
For a detailed discussion, see the \code{vignette("pcaMethods")} and \code{vignette("missingValues", "pcaMethods")} as well as the References section.

\strong{Important Note}

\code{impute_bpca()} depends on the \code{pcaMethods} package from Bioconductor. If \code{metamorphr} was installed via \code{install.packages()}, dependencies from Bioconductor were not
automatically installed. When \code{impute_bpca()} is called without the \code{pcaMethods} package installed, you should be asked if you want to install \code{pak} and \code{pcaMethods}.
If you want to use \code{impute_bpca()} you have to install those. In case you run into trouble with the automatic installation, please install \code{pcaMethods} manually. See
\href{https://www.bioconductor.org/packages/release/bioc/html/pcaMethods.html}{pcaMethods – a Bioconductor package providing PCA methods for incomplete data}.
}
\examples{
toy_metaboscape \%>\%
  impute_bpca()
}
\references{
\itemize{
\item H. R. Wolfram Stacklies, \strong{2017}, DOI 10.18129/B9.BIOC.PCAMETHODS.
\item W. Stacklies, H. Redestig, M. Scholz, D. Walther, J. Selbig, \emph{Bioinformatics} \strong{2007}, \emph{23}, 1164–1167, DOI 10.1093/bioinformatics/btm069.
}
}
