% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_greengenes}
\alias{parse_greengenes}
\title{Parse Greengenes release}
\usage{
parse_greengenes(tax_file, seq_file = NULL)
}
\arguments{
\item{tax_file}{(\code{character} of length 1) The file path to the
greengenes taxonomy file.}

\item{seq_file}{(\code{character} of length 1) The file path to the
greengenes sequence fasta file. This is optional.}
}
\value{
\code{\link{taxmap}}
}
\description{
Parses the greengenes database.
}
\details{
The taxonomy input file has a format like:

\preformatted{
228054  k__Bacteria; p__Cyanobacteria; c__Synechococcophycideae; o__Synech...
844608  k__Bacteria; p__Cyanobacteria; c__Synechococcophycideae; o__Synech...
...
}

The optional sequence file has a format like:

\preformatted{
>1111886
AACGAACGCTGGCGGCATGCCTAACACATGCAAGTCGAACGAGACCTTCGGGTCTAGTGGCGCACGGGTGCGTA...
>1111885
AGAGTTTGATCCTGGCTCAGAATGAACGCTGGCGGCGTGCCTAACACATGCAAGTCGTACGAGAAATCCCGAGC...
...
}
}
\seealso{
Other parsers: \code{\link{parse_mothur_tax_summary}},
  \code{\link{parse_mothur_taxonomy}},
  \code{\link{parse_newick}}, \code{\link{parse_phyloseq}},
  \code{\link{parse_phylo}},
  \code{\link{parse_qiime_biom}}, \code{\link{parse_rdp}},
  \code{\link{parse_silva_fasta}},
  \code{\link{parse_unite_general}}
}
