% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformdata.back.R
\name{transformdata.back}
\alias{transformdata.back}
\title{Data transformation}
\usage{
transformdata.back(
  i.data,
  i.name = "rates",
  i.cutoff.original = NA,
  i.range.x.final = NA,
  i.fun = mean
)
}
\arguments{
\item{i.data}{Data frame of input data.}

\item{i.name}{Name of the column that contains the values.}

\item{i.cutoff.original}{Cutoff point between seasons when they have two years}

\item{i.range.x.final}{Range of the surveillance period in the output dataset}

\item{i.fun}{sumarize function}
}
\value{
\code{transformdata.back} returns a data.frame with three columns, year, week and rate.
}
\description{
Function \code{transformdata.back} transforms data from week,rate1,...,rateN to year,week,rate
format.
}
\details{
Transforms data from the season in each column format (the one that uses \link{mem})
to the format year, week, rate in a 3 columns data.frame.

Allows to set the cutoff point to separate between two seasons when one season has
two different years.
}
\examples{
# Castilla y Leon Influenza Rates data
data(flucyl)
# Transform data
newdata <- transformdata.back(flucyl)$data
}
\references{
Vega T, Lozano JE, Ortiz de Lejarazu R, Gutierrez Perez M. Modelling influenza epidemic - can we
detect the beginning and predict the intensity and duration? Int Congr Ser. 2004 Jun;1263:281-3.

Vega T, Lozano JE, Meerhoff T, Snacken R, Mott J, Ortiz de Lejarazu R, et al. Influenza surveillance
in Europe: establishing epidemic thresholds by the moving epidemic method. Influenza Other Respir
Viruses. 2013 Jul;7(4):546-58. DOI:10.1111/j.1750-2659.2012.00422.x.

Vega T, Lozano JE, Meerhoff T, Snacken R, Beaute J, Jorgensen P, et al. Influenza surveillance in
Europe: comparing intensity levels calculated using the moving epidemic method. Influenza Other
Respir Viruses. 2015 Sep;9(5):234-46. DOI:10.1111/irv.12330.

Lozano JE. lozalojo/mem: Second release of the MEM R library. Zenodo [Internet]. [cited 2017 Feb 1];
Available from: \url{https://zenodo.org/record/165983}. DOI:10.5281/zenodo.165983
}
\author{
Jose E. Lozano \email{lozalojo@gmail.com}
}
\keyword{influenza}
