% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso_trapezoid_maze.r
\name{iso_trapezoid_maze}
\alias{iso_trapezoid_maze}
\title{iso_trapezoid_maze .}
\usage{
iso_trapezoid_maze(depth, unit_len = 4L, clockwise = TRUE,
  start_from = c("midpoint", "corner"), method = c("four_trapezoids",
  "one_ear", "random"), draw_boundary = FALSE, num_boundary_holes = 2,
  boundary_lines = TRUE, boundary_holes = NULL,
  boundary_hole_color = NULL, end_side = 1)
}
\arguments{
\item{depth}{the depth of recursion. This controls the
side length: three sides have \code{round(2^depth)} segments
of length \code{unit_len}, while the long side is twice as long.
\code{depth} need not be integral.}

\item{unit_len}{the unit length in graph coordinates. This controls
the width of the \sQuote{holes} in the boundary lines and
generally controls the spacing of mazes.}

\item{clockwise}{whether to draw clockwise.}

\item{start_from}{whether to start from the midpoint of the first side
of a maze, or from the corner facing the first side.}

\item{method}{there are many ways to recursive draw an isosceles
trapezoid.  The following values are acceptable:
\describe{
\item{four_trapezoids}{Four isosceles trapezoids are packed around each
other with a \sQuote{bone} between them.}
\item{one_ear}{A parallelogram is placed next to an equilateral triangle
(an \sQuote{ear}). Note this method is acceptable when depth is
not an integer.}
\item{random}{A method is chosen uniformly at random.}
}}

\item{draw_boundary}{a boolean indicating whether a final boundary shall be
drawn around the maze.}

\item{num_boundary_holes}{the number of boundary sides which should be
randomly selected to have holes. Note that the \code{boundary_holes}
parameter takes precedence.}

\item{boundary_lines}{indicates which of the sides of the maze
shall have drawn boundary lines. Can be a logical array indicating
which sides shall have lines, or a numeric array, giving the
index of sides that shall have lines.}

\item{boundary_holes}{an array indicating which of the boundary lines
have holes. If \code{NULL}, then boundary holes are randomly selected
by the \code{num_boundary_holes} parameter. If numeric, indicates
which sides of the maze shall have holes. If a boolean array, indicates
which of the sides shall have holes. These forms are recycled
if needed. See \code{\link{holey_path}}. Note that if no line
is drawn, no hole can be drawn either.}

\item{boundary_hole_color}{the color of boundary holes. A value of
\code{NULL} indicates no colored holes. See \code{\link{holey_path}}
for more details. Can be an array of colors, or colors and the 
value \code{'clear'}, which stands in for \code{NULL} to
indicate no filled hole to be drawn.}

\item{end_side}{the number of the side to end on. A value of
1 corresponds to the starting side, while higher numbers
correspond to the drawn side of the figure in the canonical order
(that is, the order induced by the \code{clockwise} parameter).}
}
\value{
nothing; the function is called for side effects only, though in
the future this might return information about the drawn boundary of
the shape.
}
\description{
Recursively draw a isosceles trapezoid maze, with three sides consisting
of \eqn{2^{depth}} pieces of length \code{unit_len}, and one long
side of length \eqn{2^{depth+1}} pieces, starting from the
long side.
}
\details{
Draws a maze in an isoscelese trapezoid with three sides of equal length
and one long side of twice that length, starting from the midpoint
of the long side (or the corner before the first side via the
\code{start_from} option). A number of different recursive methods
are supported.
Optionally draws boundaries around the trapezoid, 
with control over which sides have lines and
holes. Three sides of the trapezoid consist of \eqn{2^{depth}} segments
of length \code{unit_len}, while the longer has \eqn{2^{depth}}. 
A number of different methods are supported.
For \code{method='four_trapezoids'}:

\if{html}{
\figure{trap-four-1.png}{options: width="100\%" alt="Figure: four trapezoids"}
}
\if{latex}{
\figure{trap-four-1.png}{options: width=7cm}
}

For \code{method='one_ear'}:

\if{html}{
\figure{trap-ear-1.png}{options: width="100\%" alt="Figure: one ear"}
}
\if{latex}{
\figure{trap-ear-1.png}{options: width=7cm}
}
}
\examples{

library(TurtleGraphics)
turtle_init(1000,1000)
turtle_hide() 
iso_trapezoid_maze(depth=4,20,clockwise=FALSE,draw_boundary=TRUE)

turtle_init(1000,1000)
turtle_hide() 
turtle_do({
iso_trapezoid_maze(depth=3,20,clockwise=TRUE,draw_boundary=TRUE,boundary_holes=3)
})

turtle_init(2000,2000)
turtle_hide() 
turtle_up()
turtle_do({
	len <- 22
	iso_trapezoid_maze(depth=log2(len),15,clockwise=TRUE,draw_boundary=TRUE,
	  boundary_holes=c(1,3),method='one_ear',boundary_hole_color=c('clear','clear','green'))
	iso_trapezoid_maze(depth=log2(len),15,clockwise=FALSE,draw_boundary=TRUE,
	  boundary_lines=c(2,3,4),boundary_holes=c(2),method='one_ear',boundary_hole_color=c('red'))
})
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{plotting}
