% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{validate_mass_props}
\alias{validate_mass_props}
\title{Validate mass properties}
\usage{
validate_mass_props(mp)
}
\arguments{
\item{mp}{Mass properties list containing the following named elements
\itemize{
\item \code{mass} Numeric mass.
\item \code{center_mass} Numeric 3-vector center of mass.
\item \code{point} Logical indicating point mass. The inertia of point masses is excluded from calculations.
\item \code{inertia} Numeric 3x3 matrix inertia tensor.
}}
}
\value{
TRUE if valid, stops otherwise
}
\description{
\code{validate_mass_props()} ensures that a mass properties list satisfies the following
constraints:
\itemize{
\item \code{mass} is non-missing and positive
\item \code{center_mass} is a 3-vector of non-missing numeric values
\item \code{point} is TRUE or FALSE
\item if \code{point} is FALSE:
\itemize{
\item \code{inertia} is positive definite
\item eigenvalues \eqn{\{\lambda_1, \lambda_2, \lambda_3\}} of  \code{inertia} satisfy the triangle inequalities:
\itemize{
\item \eqn{\lambda_1 < \lambda_2 + \lambda_3}
\item \eqn{\lambda_2 < \lambda_1 + \lambda_3}
\item \eqn{\lambda_3 < \lambda_1 + \lambda_2}
}
}
}
}
\examples{
mp <- get_mass_props(test_table, "C.1")
validate_mass_props(mp)

}
