% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{set_mass_props}
\alias{set_mass_props}
\title{Set mass properties for a row in a data frame}
\usage{
set_mass_props(df, id, mp)
}
\arguments{
\item{df}{A data frame with an \code{id} column.}

\item{id}{The \code{id} value of the desired row.}

\item{mp}{A list with the following named elements:
\itemize{
\item \code{mass} Numeric mass.
\item \code{center_mass} Numeric 3-vector center of mass.
\item \code{point} Logical indicating point mass. The inertia of point masses is excluded from calculations.
\item \code{poi_conv} Enumeration c("+", "-") indicating sign convention for products of inertia.
\item \code{inertia} Numeric 3x3 matrix inertia tensor. The signs of the products of inertia
are determined by \code{POIconv}. For example, \code{Ixy} is the \eqn{xy} element of the inertia
tensor if \code{POIconv} is "-"; it is the additive inverse of that value if \code{POIconv} is "+".
}}
}
\value{
The updated data frame with columns \code{id}, \code{mass}, \code{Cx},
\code{Cy}, \code{Cz}, \code{Ixx}, \code{Iyy}, \code{Izz}, \code{Ixy}, \code{Ixz}, \code{Iyz}, \code{POIconv}, \code{Ipoint}.
}
\description{
\code{set_mass_props()} sets mass properties for a specified row in a data frame.
}
\examples{
df <- data.frame(id = c("C.1.2.2.3.1.2.3", "C.1.2.2.3.2.1.1"))
mp <- get_mass_props(mp_table, "C.1.2.2.3.2.1.1")
mp$poi_conv = "+"
set_mass_props(df, "C.1.2.2.3.2.1.1", mp)

}
