% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directory.R
\name{file_utils}
\alias{file_utils}
\alias{open_file}
\alias{shell_exec}
\alias{list_files}
\alias{list_dirs}
\title{Open a file using windows file associations}
\usage{
open_file(x)

shell_exec(x)

list_files(
  x = ".",
  pattern = NULL,
  ignore_case = FALSE,
  all = FALSE,
  negate = FALSE,
  basename = FALSE
)

list_dirs(
  x = ".",
  pattern = NULL,
  ignore_case = FALSE,
  all = FALSE,
  basename = FALSE,
  negate = FALSE
)
}
\arguments{
\item{x}{A character vector of paths}

\item{pattern}{an optional \link[base]{regular expression}.  Only file names
    which match the regular expression will be returned.}

\item{ignore_case}{logical. Should pattern-matching be case-insensitive?}

\item{all}{a logical value. If FALSE, only the names of visible files are
returned (following Unix-style visibility, that is files whose name does
not start with a dot). If TRUE, all file names will be returned.}

\item{negate}{Logical, if \code{TRUE} will inversely select files that do not
match the provided pattern}

\item{basename}{If \code{TRUE} only searches pattern on the basename, otherwise on
the entire path}
}
\value{
\itemize{
\item \code{open_file()}, \code{shell_exec()}: A logical vector where \code{TRUE} successfully opened, \code{FALSE} did not and \code{NA} did not try to open (file not found)
\item \code{list_files()}, \code{list_dirs()}: A vector of full paths
}
}
\description{
Opens the given files(s)
}
\details{
\code{open_file} is an alternative to \code{shell.exec()} that can take take
multiple files.
\code{list_files} and \code{list_dirs} are mostly wrappers for \code{\link[base:list.files]{base::list.files()}} and
\code{\link[base:list.files]{base::list.dirs()}} with preferred defaults and pattern searching on the
full file path.
}
