## -----------------------------------------------------------------------------
## Freezing Temperature of Sea Water
## -----------------------------------------------------------------------------

sw_tfreeze <- function(S = 35, p = P-1.013253, P = 1.013253) {
  if (any (S<0))
    stop ("Salinity should be >= 0")

  return(-0.0575*S + 1.710523e-3*S^1.5 - 2.154996e-4*S^2 - 7.53e-3*p)
}
