% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio.R
\name{write_portfolio}
\alias{write_portfolio}
\title{Writing a portfolio to disk}
\usage{
write_portfolio(x, dsn, overwrite = FALSE, ...)
}
\arguments{
\item{x}{A portfolio object processed with \code{{mapme.biodiversity}}}

\item{dsn}{A file path for the output file. Should end with \code{'.gpkg'}}

\item{overwrite}{A logical indicating if the output file should be overwritten
if it exists}

\item{...}{Additional arguments supplied to \code{st_write()}}
}
\value{
\code{x}, invisibly
}
\description{
The function is used to save a processes biodiversity portfolio to disk.
In order to ensure interoperability with other geospatial software the only
supported format is the GeoPackage. If any other format is chosen, the
function will automatically replace the supplied file extension with '.gpkg'.
The metadata of a portfolio together with the geometry will be written
to a table called 'metadata'. All available and supported indicators, which
are expected to be present as a nested list columns will be written to their
own respective tables. In order to allow re-joining the metadata with the
indicators, it is expected that a column called 'assetid' which uniquely
identifies all assets is present. Usually, users do not have to take care of
this since the usual \code{{mapme.biodiversity}} workflow will ensure that this
columns is present. Additional arguments to \code{st_write()} can be supplied.
}
\keyword{function}
