% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_wctmin.R
\docType{data}
\name{wctmin}
\alias{wctmin}
\title{Calculate minimum temperature statistics based on WorldClim}
\format{
A tibble with a column for minimum temperature statistics (in °C)
}
\description{
This function allows to efficiently calculate minimum temperature statistics
from Worldclim for polygons. For each polygon, the desired statistic/s (min,
max, sum, mean, median, sd or var) is/are returned.
The required resources for this indicator are:
\itemize{
\item minimum temperature layer from \link{worldclim}
}
}
\details{
The following arguments can be set:
\describe{
\item{stats_worldclim}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
}
\examples{
library(sf)
library(mapme.biodiversity)

temp_loc <- file.path(tempdir(), "mapme.biodiversity")
if(!file.exists(temp_loc)){
dir.create(temp_loc)
resource_dir <- system.file("res", package = "mapme.biodiversity")
file.copy(resource_dir, temp_loc, recursive = TRUE)
}

(try(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
                        package = "mapme.biodiversity") \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2018,
    outdir = file.path(temp_loc, "res"),
    tmpdir = tempdir(),
    add_resources = FALSE,
    cores = 1,
    verbose = FALSE
  ) \%>\%
  get_resources("mintemperature") \%>\%
  calc_indicators("wctmin", stats_worldclim = c("mean", "median"), engine = "extract") \%>\%
  tidyr::unnest(wctmin)))
}
\keyword{indicator}
