% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_med.R
\name{delta_med}
\alias{delta_med}
\title{Delta_Med by Liu, Yuan, and Li (2023)}
\usage{
delta_med(
  x,
  y,
  m,
  fit,
  paths_to_remove = NULL,
  boot_out = NULL,
  level = 0.95,
  progress = TRUE,
  skip_check_single_x = FALSE,
  skip_check_m_between_x_y = FALSE,
  skip_check_x_to_y = FALSE,
  skip_check_latent_variables = FALSE,
  boot_type = c("perc", "bc")
)
}
\arguments{
\item{x}{The name of the \code{x} variable.
Must be supplied as a quoted string.}

\item{y}{The name of the \code{y} variable.
Must be supplied as a quoted string.}

\item{m}{A vector of the variable
names of the mediator(s). If more
than one mediators, they do not have
to be on the same path from \code{x}
to \code{y}.
Cannot be \code{NULL} for this function.}

\item{fit}{The fit object. Must be a
\link[lavaan:lavaan-class]{lavaan::lavaan} object.}

\item{paths_to_remove}{A character
vector of paths users want to
manually remove, specified in
\code{lavaan} model syntax. For example,
\code{c("m2~x", "m3~m2")} removes the
path from \code{x} to \code{m2} and the path
from \code{m2} to \code{m3}. The default is
\code{NULL}, and the paths to remove will
be determined using the method
by Liu et al. (2023). If supplied,
then only paths specified explicitly
will be removed.}

\item{boot_out}{The
output of \code{\link[=do_boot]{do_boot()}}. If supplied,
the stored bootstrap estimates will
be used to form the nonparametric
percentile bootstrap confidence
interval of Delta_Med.}

\item{level}{The level of confidence
of the bootstrap confidence interval.
Default is .95.}

\item{progress}{Logical. Display
bootstrapping progress or not.
Default is \code{TRUE}.}

\item{skip_check_single_x}{Logical
Check whether the model has one and
only one x-variable. Default is \code{TRUE}.}

\item{skip_check_m_between_x_y}{Logical. Check whether all \code{m}
variables are along a path from \code{x}
to \code{y}. Default is \code{TRUE}.}

\item{skip_check_x_to_y}{Logical.
Check whether there is a direct path
from \code{x} to \code{y}. Default is \code{TRUE}.}

\item{skip_check_latent_variables}{Logical. Check whether the model
has any latent variables. Default
is \code{TRUE}.}

\item{boot_type}{If bootstrap
confidence interval is to be formed,
the type of bootstrap confidence
interval. The supported types
are \code{"perc"} (percentile bootstrap
confidence interval, the default and
recommended type) and \code{"bc"}
(bias-corrected, or BC, bootstrap
confidence interval).}
}
\value{
A \code{delta_med} class object.
It is a list-like object with these
major elements:
\itemize{
\item \code{delta_med}: The Delta_Med.
\item \code{x}: The name of the \code{x}-variable.
\item \code{y}: The name of the \code{y}-variable.
\item \code{m}: A character vector of the
mediator(s) along a path. The path
runs from the first element to the
last element.
}

This class has a \code{print} method,
a \code{coef} method, and a \code{confint}
method. See \code{\link[=print.delta_med]{print.delta_med()}},
\code{\link[=coef.delta_med]{coef.delta_med()}}, and
\code{\link[=confint.delta_med]{confint.delta_med()}}.
}
\description{
It computes the
Delta_Med proposed by Liu, Yuan,
and Li (2023), an \eqn{R^2}-like measure of
indirect effect.
}
\details{
It computes Delta_Med, an
\eqn{R^2}-like effect
size measure for the indirect effect
from one variable (the \code{y}-variable)
to another variable (the \code{x}-variable)
through one or more mediators
(\code{m}, or \code{m1}, \code{m2}, etc. when
there are more than one mediator).

The Delta_Med of one or more
mediators was computed as the
difference between
two \eqn{R^2}s:
\itemize{
\item \eqn{R^2_1}, the \eqn{R^2} when \code{y}
is predicted by \code{x} and all
mediators.
\item \eqn{R^2_2}, the \eqn{R^2} when the
mediator(s) of
interest is/are removed from the
models, while the error term(s)
of the mediator(s) is/are kept.
}

Delta_Med is given by
\eqn{R^2_1 - R^2_2}.

Please refer to Liu et al. (2023)
for the technical details.

The function can also form a
nonparametric percentile bootstrap
confidence of Delta_Med.
}
\section{Implementation}{
The function identifies all the
path(s) pointing to the mediator(s)
of concern and fixes the path(s) to
zero, effectively removing the
mediator(s). However, the model is
not refitted, hence keeping the
estimates of all other parameters
unchanged.
It then uses \code{\link[lavaan:lav_model]{lavaan::lav_model_set_parameters()}}
to update the parameters,
\code{\link[lavaan:lav_model]{lavaan::lav_model_implied()}} to
update the implied statistics, and
then calls \code{\link[lavaan:lavInspect]{lavaan::lavInspect()}} to
retrieve the implied variance of the
predicted values of \code{y} for computing
the \eqn{R^2_2}. Subtracting this
\eqn{R^2_2} from \eqn{R^2_1} of
\code{y} can then yield Delta_Med.
}

\section{Model Requirements}{
For now, by default, it only
computes Delta_Med
for the types
of models discussed in
Liu et al. (2023):
\itemize{
\item Having one predictor (the
\code{x}-variable).
\item Having one or more mediators, the
\code{m}-variables, with
arbitrary way to mediate the effect
of \code{x} on the outcome variable
(\code{y}-variable).
\item Having one or more outcome variables.
Although their models only have
outcome variables, the computation
of the Delta_Med is not affected
by the presence of other outcome
variables.
\item Having no control variables.
\item The mediator(s), \code{m}, and the
\code{y}-variable are continuous.
\item \code{x} can be continuous
or categorical. If categorical, it
needs to be handle appropriately
when fitting the model.
\item \code{x} has a direct
path to \code{y}.
\item All the mediators listed in the
argument \code{m} is present in at least
one path from \code{x} to \code{y.}
\item None of the paths from \code{x} to \code{y}
are moderated.
}

It can be used for other kinds
of models but support for them is
disabled by default. To use
this function for
cases not discussed in
Liu et al. (2023), please disable
relevant requirements stated above
using the relevant
\verb{skip_check_*} arguments. An error
will be raised if the models failed
any of the checks not skipped by
users.
}

\examples{

library(lavaan)
dat <- data_med
mod <-
"
m ~ x
y ~ m + x
"
fit <- sem(mod, dat)
dm <- delta_med(x = "x",
                y = "y",
                m = "m",
                fit = fit)
dm
print(dm, full = TRUE)

# Call do_boot() to generate
# bootstrap estimates
# Use 2000 or even 5000 for R in real studies
# Set parallel to TRUE in real studies for faster bootstrapping
boot_out <- do_boot(fit,
                    R = 45,
                    seed = 879,
                    parallel = FALSE,
                    progress = FALSE)
# Remove 'progress = FALSE' in practice
dm_boot <- delta_med(x = "x",
                     y = "y",
                     m = "m",
                     fit = fit,
                     boot_out = boot_out,
                     progress = FALSE)
dm_boot
confint(dm_boot)


}
\references{
Liu, H., Yuan, K.-H., & Li, H. (2023).
A systematic framework for defining
R-squared measures in mediation
analysis. \emph{Psychological Methods}.
Advance online publication.
https://doi.org/10.1037/met0000571
}
\seealso{
\code{\link[=print.delta_med]{print.delta_med()}},
\code{\link[=coef.delta_med]{coef.delta_med()}}, and
\code{\link[=confint.delta_med]{confint.delta_med()}}.
}
