% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolISOhistorical.R
\name{toolISOhistorical}
\alias{toolISOhistorical}
\title{Tool: ISOhistorical}
\usage{
toolISOhistorical(m, mapping = NULL, additional_mapping = NULL,
  overwrite = FALSE)
}
\arguments{
\item{m}{MAgPIE object with ISO country codes in the spatial dimension}

\item{mapping}{mapping of historical ISO countries to the standard ISO
country list. For the default setting (mapping=NULL) the mapping stored as
supplementary data in the madrat package is used.}

\item{additional_mapping}{vector or list of vectors to provide some specific
mapping, first the old country code, second the new country code and last
the last year of the old country, e.g. additional_mapping =
c("TTT","TTX","y1111") or additional_mapping =
list(c("TTT","TTX","y1111"),c("TTT","TTY","y1111"))}

\item{overwrite}{if there are already historical data in the data source for
years that are calculated in this function they will not be overwritten by
default. To overwrite all data (e.g. if there are meaningless "0") choose
overwrite=TRUE}
}
\value{
A MAgPIE object with spatial entries for each country of the
official ISO code country list. Historical time is filled up, old countries
deleted
}
\description{
This function expects a MAgPIE object with ISO country codes in the spatial
dimension. For this MAgPIE object the time of transition is calculated and
for each the historic time filled by using the mapping stored as
supplementary data in the madrat package. If you want to use a different
mapping please specify it in the argument mapping
}
\author{
Lavinia Baumstark
}
