% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlsbclust.R
\name{rlsbclust}
\alias{rlsbclust}
\title{Simulate from LSBCLUST Model}
\usage{
rlsbclust(ndata = 50L, nobs, size, nclust, clustsize = NULL,
  delta = rep(1L, 4L), ndim = 2L, alpha = 0.5, fixed = c("none",
  "rows", "columns"), err_sd = 1, svmins = 1, svmax = 6)
}
\arguments{
\item{ndata}{Integer giving the number of data sets to generate with the same underlying
parameters.}

\item{nobs}{Integer giving the number of observations to sample.}

\item{size}{Vector with two elements giving the number of rows and columns respectively
of each simulated observation.}

\item{nclust}{A vector of length four giving the number of clusters for the overall mean, the row
margins, the column margins and the interactions (in that order) respectively. Alternatively, a
vector of length one, in which case all components will have the same number of clusters.}

\item{clustsize}{A list of length four, with each element containing a vector 
of the same length as the corresponding entry in \code{nclust}, indicating the 
number of elements to contribute to each sample. Naturally, each of these 
vectors must sum to \code{nobs}, or an error will result. Positional matching 
are used, in the order "overall", "rows", "columns" and "interactions". If 
\code{NULL}, all clusters will be of equal size.}

\item{delta}{A four-element binary vector (logical or numeric) indicating which sum-to-zero 
constraints must be enforced.}

\item{ndim}{The required rank for the approximation of the interactions (a scalar).}

\item{alpha}{Numeric value in [0, 1] which determines how the singular values are distributed
between rows and columns (passed to \code{\link{int.lsbclust}}).}

\item{fixed}{One of \code{"none"}, \code{"rows"} or \code{"columns"} indicating whether to fix neither
sets of coordinates, or whether to fix the row or column coordinates across clusters respectively.
If a vector is supplied, only the first element will be used (passed to \code{\link{int.lsbclust}}).}

\item{err_sd}{The standard deviation of the error distribution, as passed to 
\code{\link{rnorm}}}

\item{svmins}{Vector of minimum values for the singular values 
(as passed to \code{\link{simsv}}). Optionally, if all minima are equal,
a single numeric value which will be expanded to the correct length.}

\item{svmax}{The maximum possible singular value (as passed to \code{\link{simsv}})}
}
\description{
Simulate three-way arrays adhering to the LSBCLUST framework (see \code{\link{lsbclust}}).
}
\examples{
## Nothing fixed, balanced classes
set.seed(1)
dat <- rlsbclust(ndata = 1, nobs = 100, size = c(10, 8), nclust = c(5, 4, 6, 5))
res <- lsbclust(data = dat[[1]]$data, nclust = c(5, 4, 6, 5))
cfsim(res, dat[[1]])

## Rows fixed, balanced classes
set.seed(2)
dat <- rlsbclust(ndata = 1, nobs = 100, size = c(10, 8), nclust = c(5, 4, 6, 5), 
                 fixed = "rows")
res <- lsbclust(data = dat[[1]]$data, nclust = c(5, 4, 6, 5), fixed = "rows")
cfsim(res, dat[[1]])

## Rows fixed, unbalanced classes
set.seed(3)
dat <- rlsbclust(ndata = 1, nobs = 100, size = c(10, 8), nclust = c(5, 4, 6, 5), 
                 fixed = "columns", 
                 clustsize = list(NULL, NULL, c(40, 25, 15, 10, 5, 5), c(40, 25, 15, 10, 10)))
res <- lsbclust(data = dat[[1]]$data, nclust = c(5, 4, 6, 5), fixed = "columns")
cfsim(res, dat[[1]])
}
