library(lpridge)
data(cars)
y.d <- cars[,"dist"]
x.s <- cars[,"speed"]

### ------ lpepa() -------------------------------------------------------------

.prtime00 <- proc.time()
epa.5  <- lpepa(x.s,y.d, bandw=5)
epa.5V <- lpepa(x.s,y.d, bandw=5, var=TRUE)
epa.5s	<- lpepa(x.s,y.d, bandw=5, mnew=1)# "super-stable"
epa.5sV <- lpepa(x.s,y.d, bandw=5, mnew=1, var=TRUE)
## Running time
cat('Time elapsed: ', (.pt <- proc.time()) - .prtime00,'\n')

if(FALSE) ## produced via
    dput(lapply(epa.5V[c("est","est.var")], signif, 7))
epa5V.tr <- list(
 est = c(5.973684, 6.294084, 6.585589, 6.855943,
	 7.110213, 7.351861, 7.583336, 7.806423, 8.022459, 8.232461, 8.414339,
	 8.604943, 8.82243, 9.057654, 9.305398, 9.562459, 9.826756, 10.09687,
	 10.3718, 10.65071, 10.93008, 11.21057, 11.49194, 11.77405, 12.05679,
	 12.34008, 12.62386, 12.90808, 13.19271, 13.46305, 13.72125, 13.97814,
	 14.23392, 14.48875, 14.74277, 14.99611, 15.24889, 15.50125, 15.75462,
	 16.02022, 16.28543, 16.55007, 16.81386, 17.07647, 17.33743, 17.59615,
	 17.85182, 18.10334, 18.33879, 18.60237, 18.90031, 19.22486, 19.5707,
	 19.93407, 20.31221, 20.70306, 21.10504, 21.51698, 21.93356, 22.35082,
	 22.76874, 23.18729, 23.60645, 24.02622, 24.4466, 24.86757, 25.28916,
	 25.70306, 26.11057, 26.51559, 26.91842, 27.31927, 27.71832, 28.11572,
	 28.51155, 28.90589, 29.30104, 29.69982, 30.09067, 30.47478, 30.85303,
	 31.2261, 31.59448, 31.95857, 32.31864, 32.67493, 33.09936, 33.55255,
	 34.00641, 34.46095, 34.91619, 35.37213, 35.82875, 36.28606, 36.74405,
	 37.18927, 37.59188, 37.99472, 38.39772, 38.80085, 39.20406, 39.6073,
	 40.01056, 40.41377, 40.8169, 41.15701, 41.48497, 41.81937, 42.15869,
	 42.50189, 42.8483, 43.19751, 43.54931, 43.90368, 44.25443, 44.5903,
	 44.92612, 45.26196, 45.59795, 45.93428, 46.27122, 46.60919, 46.94876,
	 47.29075, 47.5664, 47.82618, 48.0862, 48.34645, 48.60696, 48.86772,
	 49.12876, 49.39009, 49.65174, 49.90126, 50.12675, 50.35363, 50.58218,
	 50.81272, 51.0457, 51.28167, 51.52138, 51.76592, 52.01681, 52.70824,
	 53.43919, 54.14445, 54.83105, 55.5038, 56.16612, 56.82046, 57.46866,
	 58.11212, 58.75434, 59.39558, 60.03228, 60.66561, 61.29647, 61.92554,
	 62.55336, 63.18036, 63.80685, 64.43309, 65.05724, 65.683, 66.31085,
	 66.94097, 67.57356, 68.2088, 68.84694, 69.48822, 70.13296, 70.78466,
	 71.4478, 72.1202, 72.80292, 73.49735, 74.20536, 74.92948, 75.6733,
	 76.44211, 77.24406, 78.14173, 79.0486, 79.96211, 80.88364, 81.81515,
	 82.75942, 83.72062, 84.70531, 85.72443, 86.75793, 87.77151, 88.79528,
	 89.83315, 90.89155, 91.98178, 93.12573, 94.37226, 95.85725, 98.15401),
 est.var = c(0.4898719, 0.455614, 0.4256579, 0.3988534, 0.3745162,
	 0.3522161, 0.3316707, 0.3126872, 0.2951301, 0.2789011, 0.263549,
	 0.2497788, 0.2374595, 0.2261708, 0.2156998, 0.2059275, 0.1967822,
	 0.1882177, 0.1802025, 0.1727145, 0.1657165, 0.1591517, 0.1529929,
	 0.1472222, 0.1418266, 0.1367967, 0.132125, 0.1278057, 0.1238341,
	 0.1200737, 0.1164903, 0.1131651, 0.1100983, 0.1072915, 0.1047476,
	 0.1024712, 0.100469, 0.09875028, 0.09732028, 0.09613503, 0.095288,
	 0.09481497, 0.09476393, 0.09519979, 0.09621138, 0.09792255, 0.1005097,
	 0.1042311, 0.1026123, 0.09752876, 0.09287479, 0.08857981, 0.08459877,
	 0.08090144, 0.0774667, 0.0742792, 0.07132748, 0.06860265, 0.06609415,
	 0.063784, 0.0616581, 0.05970648, 0.05792181, 0.05629851, 0.05483221,
	 0.05351939, 0.05235713, 0.05131926, 0.05040067, 0.04960828, 0.04894089,
	 0.04839798, 0.04797964, 0.04768663, 0.04752044, 0.04748344, 0.04733872,
	 0.0462957, 0.04536504, 0.04454362, 0.0438294, 0.04322095, 0.04271727,
	 0.04231754, 0.04202109, 0.04182728, 0.04123501, 0.040536, 0.0399284,
	 0.03941171, 0.03898552, 0.03864959, 0.03840373, 0.03824784, 0.0381819,
	 0.03806323, 0.0375901, 0.03722144, 0.03695211, 0.03677873, 0.03669913,
	 0.03671213, 0.03681734, 0.03701518, 0.03730684, 0.03679217, 0.03614274,
	 0.03562636, 0.03522814, 0.03493849, 0.03475129, 0.03466289, 0.03467156,
	 0.03477722, 0.03490641, 0.03494206, 0.0350685, 0.03528606, 0.03559544,
	 0.0359978, 0.03649482, 0.03708897, 0.03778385, 0.03858472, 0.038971,
	 0.03933335, 0.03979418, 0.0403534, 0.04101091, 0.04176659, 0.04262033,
	 0.04357191, 0.04462103, 0.04554349, 0.0461186, 0.04679535, 0.04757363,
	 0.04845327, 0.0494341, 0.05051608, 0.05169951, 0.05298548, 0.05437689,
	 0.05302476, 0.05166235, 0.05066921, 0.04996404, 0.04949455, 0.04922579,
	 0.04913382, 0.04920183, 0.04941795, 0.04948033, 0.04923189, 0.04915113,
	 0.04922701, 0.04945165, 0.04981941, 0.05032623, 0.05096928, 0.05174662,
	 0.05265705, 0.05358182, 0.05464332, 0.05585514, 0.0572178, 0.05873202,
	 0.06039871, 0.06221899, 0.06419419, 0.06632592, 0.06857804, 0.07096997,
	 0.07356656, 0.07637049, 0.07938512, 0.08261481, 0.08606549, 0.0897456,
	 0.09366781, 0.09785263, 0.1023737, 0.1072321, 0.1124357, 0.1179978,
	 0.1239382, 0.130288, 0.1370977, 0.1444563, 0.1525316, 0.1613084,
	 0.1704962, 0.1803775, 0.1910924, 0.2029069, 0.2163727, 0.2327872,
	 0.2557982, 0.2990685, 0.4521012))

n1 <- names(epa.5); n1 <- n1[- grep("var",n1)]
stopifnot(all.equal(epa.5 [n1], epa.5V [n1], tol=1e-15),
	  all.equal(epa.5s[n1], epa.5sV[n1], tol=1e-15),
	  all.equal(epa.5V[c("est","est.var")], epa5V.tr, tol=2e-7)
	  )



### ------ lpridge() -----------------------------------------------------------

.prtime00 <- proc.time()
lpr.5r	<- lpridge(x.s,y.d, bandw = 5, ridge=0) # local polynomials
lpr.5rV <- lpridge(x.s,y.d, bandw = 5, ridge=0, var=TRUE)
## these must be equal to epa , as  ridge = 0 :
(nms2 <- intersect(names(epa.5V), names(lpr.5rV)))
stopifnot(all.equal(epa.5V[nms2], lpr.5rV[nms2], tol= 1e-15),
	  all.equal(epa.5 [nms2], lpr.5r [nms2], tol= 1e-15))

lpr.5  <-  lpridge(x.s,y.d, bandw = 5)		 # local pol.+ridge
lpr.5V <-  lpridge(x.s,y.d, bandw = 5, var=TRUE) # local pol.+ridge
lpr.5s	<- lpridge(x.s,y.d, bandw = 5, mnew=1)# "super-stable"
lpr.5sV <- lpridge(x.s,y.d, bandw = 5, mnew=1, var=TRUE)
## Running time
cat('Time elapsed: ', (.pt <- proc.time()) - .prtime00,'\n')


if(FALSE) ## produced via
    dput(lapply(lpr.5V[c("est","est.var")], function(x) signif(100 * x, 7)))
lpr5V.tr <- list(
 est = c(667.2444, 689.274, 710.0057, 729.8122,
		 748.9486, 767.5952, 785.8819, 803.9036, 821.7303, 839.4131, 857.0399,
		 877.1556, 899.3505, 922.8604, 947.2731, 972.3531, 997.9608, 1024.01,
		 1050.448, 1077.286, 1105.181, 1133.001, 1160.762, 1188.481, 1216.175,
		 1243.863, 1271.56, 1299.279, 1327.032, 1354.017, 1380.163, 1406.042,
		 1431.696, 1457.16, 1482.467, 1507.645, 1532.72, 1557.718, 1582.915,
		 1610.404, 1637.758, 1664.969, 1692.028, 1718.921, 1745.623, 1772.1,
		 1798.302, 1824.156, 1848.218, 1874.579, 1904.042, 1935.926, 1969.768,
		 2005.247, 2042.13, 2080.244, 2119.46, 2159.735, 2200.786, 2241.895,
		 2283.069, 2324.317, 2365.644, 2407.056, 2448.559, 2490.155, 2531.848,
		 2572.893, 2613.358, 2653.592, 2693.625, 2733.48, 2773.175, 2812.724,
		 2852.137, 2891.419, 2930.791, 2970.514, 3009.469, 3047.774, 3085.514,
		 3122.753, 3159.541, 3195.913, 3231.895, 3267.507, 3309.945, 3355.261,
		 3400.645, 3446.097, 3491.62, 3537.213, 3582.875, 3628.606, 3674.405,
		 3718.926, 3759.188, 3799.471, 3839.772, 3880.084, 3920.404, 3960.728,
		 4001.053, 4041.373, 4081.685, 4115.699, 4148.495, 4181.936, 4215.868,
		 4250.188, 4284.83, 4319.751, 4354.931, 4390.368, 4425.443, 4459.029,
		 4492.611, 4526.196, 4559.794, 4593.427, 4627.121, 4660.917, 4694.873,
		 4729.073, 4756.636, 4782.611, 4808.608, 4834.627, 4860.67, 4886.738,
		 4912.832, 4938.955, 4965.11, 4990.046, 5012.56, 5035.205, 5058.006,
		 5080.996, 5104.218, 5127.728, 5151.599, 5175.938, 5200.897, 5269.985,
		 5343.045, 5413.538, 5482.166, 5549.409, 5615.61, 5681.015, 5745.81,
		 5810.137, 5874.321, 5938.359, 6001.934, 6065.166, 6128.145, 6190.943,
		 6253.616, 6316.208, 6378.757, 6441.293, 6503.455, 6565.745, 6628.232,
		 6690.939, 6753.891, 6817.117, 6880.646, 6944.516, 7008.772, 7073.527,
		 7139.069, 7205.479, 7272.873, 7341.398, 7411.25, 7482.696, 7556.112,
		 7632.04, 7711.313, 7798.731, 7886.763, 7975.22, 8064.243, 8154.026,
		 8244.844, 8337.092, 8431.372, 8528.648, 8625.177, 8716.95, 8808.285,
		 8899.213, 8989.773, 9079.998, 9169.895, 9259.369, 9347.963, 9433.618)/100,
 est.var = c(41.05341, 39.03483, 37.17017, 35.42359, 33.7734,
		 32.20632, 30.71429, 29.29277, 27.93954, 26.65409, 25.33091, 24.06695,
		 22.93165, 21.89073, 20.92572, 20.02557, 19.18315, 18.39366, 17.65373,
		 16.95941, 16.28086, 15.64742, 15.05557, 14.50278, 13.98715, 13.50726,
		 13.06199, 12.65049, 12.27212, 11.90002, 11.53762, 11.20339, 10.89688,
		 10.61777, 10.36596, 10.14155, 9.944885, 9.776615, 9.635672, 9.50653,
		 9.411561, 9.353821, 9.337491, 9.368299, 9.45415, 9.606103, 9.839903,
		 10.17851, 10.02379, 9.548239, 9.111407, 8.707089, 8.331288, 7.981313,
		 7.655288, 7.351874, 7.070089, 6.808736, 6.565004, 6.340354, 6.133444,
		 5.943328, 5.769315, 5.610886, 5.467644, 5.339276, 5.225532, 5.123409,
		 5.032798, 4.954652, 4.888861, 4.835384, 4.794244, 4.765526, 4.749393,
		 4.746093, 4.732006, 4.628225, 4.53556, 4.45372, 4.382521, 4.321836,
		 4.271576, 4.231674, 4.202071, 4.182713, 4.123492, 4.053594, 3.992837,
		 3.941169, 3.898552, 3.864959, 3.840373, 3.824784, 3.81819, 3.806323,
		 3.75901, 3.722144, 3.695212, 3.677873, 3.669913, 3.671213, 3.681734,
		 3.701517, 3.730684, 3.679217, 3.614274, 3.562636, 3.522814, 3.493849,
		 3.475129, 3.466289, 3.467156, 3.477722, 3.490641, 3.494206, 3.506849,
		 3.528605, 3.559544, 3.599779, 3.64948, 3.708895, 3.778382, 3.858469,
		 3.897093, 3.933321, 3.979392, 4.035297, 4.101024, 4.176562, 4.261899,
		 4.357016, 4.461884, 4.554061, 4.611419, 4.678891, 4.756455, 4.844086,
		 4.94176, 5.049463, 5.167216, 5.295114, 5.433427, 5.299036, 5.163515,
		 5.064665, 4.994456, 4.947712, 4.920974, 4.91187, 4.918735, 4.940397,
		 4.946642, 4.921704, 4.913483, 4.920879, 4.943109, 4.979612, 5.029988,
		 5.093961, 5.171346, 5.262039, 5.353681, 5.458825, 5.578878, 5.7139,
		 5.86398, 6.029236, 6.209815, 6.405903, 6.617724, 6.840712, 7.076015,
		 7.33131, 7.606889, 7.903139, 8.220573, 8.559891, 8.922073, 9.308544,
		 9.721515, 10.15718, 10.62313, 11.12038, 11.64997, 12.21354, 12.81372,
		 13.45477, 14.1441, 14.89541, 15.69072, 16.49518, 17.34308, 18.23982,
		 19.19672, 20.23846, 21.42399, 22.91628, 25.28407, 31.54264)/100)

n2 <- names(lpr.5); n2 <- n2[- grep("var",n2)]
stopifnot(all.equal(lpr.5 [n2], lpr.5V [n2], tol=1e-15),
	  all.equal(lpr.5s[n2], lpr.5sV[n2], tol=1e-15),
	  all.equal(lpr.5V[c("est","est.var")], lpr5V.tr, tol=2e-7)
	  )
