% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{raster_se_sig}
\alias{raster_se_sig}
\title{Calculate One-Sided Confidence Level (\%)}
\usage{
raster_se_sig(muvari)
}
\arguments{
\item{muvari}{SpatRaster, of mean (location) values, variances corresponding to each \code{mu} to test against zero.}
}
\value{
A SpatRaster of confidence levels (0-100\%), each rounded to one decimal place.
}
\description{
Computes the one-sided confidence level, defined as (1 - p-value) x 100, for testing whether each mean (\code{mu}) differs from zero under a normal approximation.
}
\details{
For each element:
\enumerate{
\item Calculate the standard error:
se = sqrt(vari).
\item Compute the absolute z-score:
z = abs(mu / se).
\item The one-sided p-value is 1 - phi(z), where phi is the CDF of the standard normal.
\item The confidence level is (1 - p-value) x 100 = phi(z) x 100.
}
}
\examples{
require(terra)
r = rast(system.file("extdata/50km_AnnMax_agcd_v1_tmax_mean_r005_daily_1980-2019.nc",
                     package = "loopevd"))
r2 = aggregate(r,4) #lower the resolution for a fast example
gev_r = raster_fevd(r2,"fgev")
raster_se_sig(c(gev_r$shape,gev_r$cov_9))
}
