% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterEstimation.R
\name{lambdaEst.ppp}
\alias{lambdaEst.ppp}
\title{lambdaEst.ppp function}
\usage{
\method{lambdaEst}{ppp}(xyt, weights = c(), edge = TRUE, bw = NULL, ...)
}
\arguments{
\item{xyt}{object of class stppp}

\item{weights}{Optional vector of weights to be attached to the points.  May include negative values. See ?density.ppp.}

\item{edge}{Logical flag: if TRUE, apply edge correction. See ?density.ppp.}

\item{bw}{optional bandwidth. Set to NULL by default, which calls teh resolve.2D.kernel function for computing an initial value of this}

\item{...}{arguments to be passed to plot}
}
\value{
This is an rpanel function for visual choice of lambda(s), the output is a variable, varname, with the density *per unit time* 
the variable varname can be fed to the function ginhomAverage or KinhomAverage as the argument density (see for example ?ginhomAverage), or into the 
function thetaEst as the argument spatial.intensity.
}
\description{
A tool for the visual estimation of lambda(s) via a 2 dimensional smoothing of the case locations. For parameter estimation, the alternative is
to estimate lambda(s) by some other means, convert it into a spatialAtRisk object and then into a pixel image object using the build in coercion 
methods, this \code{im} object can then be fed to \link{ginhomAverage}, \link{KinhomAverage} or \link{thetaEst} for instance.
}
\details{
The function lambdaEst is built directly on the density.ppp function and as such, implements a bivariate 
Gaussian smoothing kernel. The bandwidth is initially that which is automatically chosen by the default method 
of density.ppp. Since image plots of these kernel density estimates may not have appropriate 
colour scales, the ability to adjust this is given with the slider 'colour adjustment'. With colour adjustment set 
to 1, the default image.plot for the equivalent pixel image object is shown and for values less than 1, the colour 
scheme is more spread out, allowing the user to get a better feel for the density that is being fitted. NOTE: colour 
adjustment does not affect the returned density and the user should be aware that the returned density will 'look like' 
that displayed when colour adjustment is set equal to 1.
}
\references{
\enumerate{
    \item Benjamin M. Taylor, Tilman M. Davies, Barry S. Rowlingson, Peter J. Diggle (2013). Journal of Statistical Software, 52(4), 1-40. URL http://www.jstatsoft.org/v52/i04/
    \item Brix A, Diggle PJ (2001). Spatiotemporal Prediction for log-Gaussian Cox processes. Journal of the Royal Statistical Society, Series B, 63(4), 823-841.
    \item Diggle P, Rowlingson B, Su T (2005). Point Process Methodology for On-line Spatio-temporal Disease Surveillance. Environmetrics, 16(5), 423-434.
}
}
\seealso{
\link{spatialAtRisk}, \link{ginhomAverage}, \link{KinhomAverage}, \link{spatialparsEst}, \link{thetaEst}, \link{muEst}
}
