% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lev-distance.R
\name{lev_distance}
\alias{lev_distance}
\title{String distance metrics}
\usage{
lev_distance(a, b, pairwise = TRUE, useNames = TRUE, ...)
}
\arguments{
\item{a, b}{The input strings}

\item{pairwise}{Boolean. If \code{TRUE}, only the pairwise distances between \code{a} and \code{b} will be
computed, rather than the combinations of all elements.}

\item{useNames}{Boolean. Use input vectors as row and column names?}

\item{...}{Additional arguments to be passed to \code{\link[stringdist:stringdist]{stringdist::stringdistmatrix()}} or
\code{\link[stringdist:stringsim]{stringdist::stringsimmatrix()}}.}
}
\value{
A numeric scalar, vector or matrix depending on the length of the inputs. See "Details".
}
\description{
Uses \code{\link[stringdist:stringdist]{stringdist::stringdistmatrix()}} to compute a range of
\link[stringdist:stringdist-metrics]{string distance metrics}.
}
\section{Details}{

This is a thin wrapper around \code{\link[stringdist:stringdist]{stringdist::stringdistmatrix()}} and mainly exists to coerce the
output into the simplest possible format (via \code{\link[=lev_simplify_matrix]{lev_simplify_matrix()}}).

The function will return the simplest possible data structure permitted by the length of the
inputs \code{a} and \code{b}. This will be a scalar if \code{a} and \code{b} are length 1, a vector if either (but
not both) is length > 1, and a matrix otherwise.
}

\section{Other options}{

In addition to \code{useNames} \code{\link[stringdist:stringdist]{stringdist::stringdistmatrix()}} provides a range of options to control
the matching, which can be passed using \code{...}. Refer to the \code{stringdist} documentation for more
information.
}

\examples{
lev_distance("Bilbo", "Frodo")

lev_distance("Bilbo", c("Frodo", "Merry"))

lev_distance("Bilbo", c("Frodo", "Merry"), useNames = FALSE)

lev_distance(c("Bilbo", "Gandalf"), c("Frodo", "Merry"))
}
