% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-stack.R
\name{compose_stack}
\alias{compose_stack}
\title{Compose guides as stack}
\usage{
compose_stack(
  ...,
  args = list(),
  key = NULL,
  title = waiver(),
  side.titles = waiver(),
  angle = waiver(),
  theme = NULL,
  order = 0,
  drop = NULL,
  position = waiver(),
  available_aes = NULL
)
}
\arguments{
\item{...}{Guides to stack in \link[=guide-composition]{composition}. Each guide
can be specified as one of the following:
\itemize{
\item A \verb{<Guide>} class object.
\item A \verb{<function>} that returns a \verb{<Guide>} class object.
\item A \verb{<character[1]>} naming such a function, without the \code{guide_} or
\code{primitive_} prefix.
}}

\item{args}{A \verb{<list>} of arguments to pass to guides that are given either
as a function or as a string.}

\item{key}{A \link[=key_standard]{standard key} specification. The key is shared
among all guides that have \code{NULL} keys themselves. See more information
in the linked topic.}

\item{title}{A \verb{<character[1]>} or \verb{<expression[1]>} indicating the title of
the guide. If \code{NULL}, the title is not shown. The default,
\code{\link[ggplot2:waiver]{waiver()}}, takes the name of the scale object or
the name specified in \code{\link[ggplot2:labs]{labs()}} as the title.}

\item{side.titles}{A \verb{<character>} giving labels for titles displayed on the
side of the stack. Set to \code{NULL} to display no side titles. If \code{waiver()},
an attempt is made to extract the titles from the guides and use these
as side titles.}

\item{angle}{A specification for the text angle. Compared to setting the \code{angle} argument
in \code{\link[ggplot2:element]{element_text()}}, this argument uses some
heuristics to automatically pick the \code{hjust} and \code{vjust} that you
probably want. Can be one of the following:
\itemize{
\item \code{NULL} to take angles and justification settings directly from the theme.
\item \code{\link[ggplot2:waiver]{waiver()}} to allow reasonable defaults in special
cases.
\item A \verb{<numeric[1]>} between -360 and 360 for the text angle in degrees.
}}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{order}{A positive \verb{<integer[1]>} that specifies the order of this guide among
multiple guides. This controls in which order guides are merged if there
are multiple guides for the same position. If \code{0} (default), the order is
determined by a hashing indicative settings of a guide.}

\item{drop}{An \verb{<integer>} giving the indices of guides that should be
dropped when a facet requests no labels to be drawn at axes in between
panels. The default, \code{NULL}, will drop every guide except the first.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{available_aes}{A \verb{<character>} giving aesthetics that must match the
the guides.}
}
\value{
A \verb{<ComposeStack>} guide object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This guide can stack other guides.
}
\examples{
ggplot() +
  geom_function(fun = dnorm, xlim = c(-3, 3)) +
  guides(x = compose_stack(
    "axis", "axis",
    side.titles = c("first", "second")
  )) +
  # Add margin to make room for side titles
  theme(plot.margin = margin(5.5, 5.5, 5.5, 11))
}
\seealso{
Other composition: 
\code{\link{compose_crux}()},
\code{\link{compose_ontop}()},
\code{\link{compose_sandwich}()},
\code{\link{guide-composition}}
}
\concept{composition}
