% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_cs.R
\name{create_cs}
\alias{create_cs}
\title{Creates a cost surface from a SpatRaster}
\usage{
create_cs(
  x,
  neighbours = 16,
  dem = NULL,
  max_slope = NULL,
  exaggeration = FALSE
)
}
\arguments{
\item{x}{\code{SpatRaster}}

\item{neighbours}{\code{numeric} value. Number of directions used in the conductance matrix calculation. Expected numeric values are 4, 8, 16, 32, 48, or matrix object. 16 (default)}

\item{dem}{\code{SpatRaster} Digital Elevation Model (DEM)}

\item{max_slope}{\code{numeric} value. Maximum percentage slope that is traversable. Slope values that are greater than the specified max_slope are given a conductivity value of 0. If cost_function argument is 'campbell 2019' then max_slope is fixed at 30 degrees slope to reflect the maximum slope that the cost function is parametised to. NULL (default)}

\item{exaggeration}{\code{logical}. if TRUE, positive slope values (up-hill movement) multiplied by 1.99 and negative slope values (down-hill movement) multiplied by 2.31}
}
\value{
\code{conductanceMatrix} that numerically expresses the difficulty of moving across a surface based on the provided SpatRaster
}
\description{
Creates a cost surface using the values in the supplied SpatRaster. This function also provides for the inclusion of maximum slope traversable
 
The supplied 'spatRaster' object must have a projected CRS
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

cs1 <- create_cs(x = r, neighbours = 16, dem = NULL, max_slope = NULL)
cs2 <- create_cs(x = r, neighbours = 16, dem = r, max_slope = 10)
}
\author{
Joseph Lewis
}
