% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-oxford_man_plot_obs.R
\name{ldhmm.oxford_man_plot_obs}
\alias{ldhmm.oxford_man_plot_obs}
\title{Plotting Oxford-Man realized volatility overlaid with HMM expected volatility}
\usage{
ldhmm.oxford_man_plot_obs(object, days.pa = 252, start.date = NULL,
  end.date = NULL, index.symbol = ".SPX", index.rv = "rv5",
  index.px = "close_price", index.px.scale = 15,
  index.px.origin = NULL, index.vol.ma.order = 5,
  vix.adj.ratio = NULL, insert.plot = TRUE, insert.viewport = NULL)
}
\arguments{
\item{object}{an ldhmm object with a stationary solution. If this is set to \code{NULL},
an internal 10-state HMM object will be used.}

\item{days.pa}{a positive integer specifying trading days per year, default is 252.}

\item{start.date}{Date or character of ISO format (YYYY-MM-DD), 
specifying the start date of the plot, default is \code{NULL}.}

\item{end.date}{Date or character of ISO format (YYYY-MM-DD), 
specifying the end date of the plot, default is \code{NULL}.}

\item{index.symbol}{character, the symbol of the index. Default is \code{.SPX}.}

\item{index.rv}{character, specifying index realized variance column, default is \code{rv5}.}

\item{index.px}{character, specifying index closing price column, default is \code{close_price}.}

\item{index.px.scale}{numeric, specifying the scaling factor when plotting price trend, default is 15.
Set this to \code{NULL} if you don't wish to see the price line.
The closing price is converted to cumulative return by the price of the first date.
Then plot from the mid-point of volatility axis with this scale.}

\item{index.px.origin}{numeric, specifying the starting value of the index price line,
the default is \code{NULL}, which will start the index price line from the middle of y-axis.}

\item{index.vol.ma.order}{a positive integer specifying the simple moving average of the realized volatility, default is 5.
This is needed because the realized volatility is very noisy at the daily level.}

\item{vix.adj.ratio}{numeric, if specified, VIX index is adjusted and plotted, default is \code{NULL}.
The long-term ratio between VIX and 10-state HMM is 0.79.
The VIX data is cached when the Oxford data is downloaded.}

\item{insert.plot}{logical, if true, also plot the volatility-return as insert in upper-right corner, default is \code{TRUE}.}

\item{insert.viewport}{optional viewport for the insert, default is \code{NULL}, 
which is internally set to \code{grid::viewport(.8, .75, .3, .3)}.}
}
\description{
This utility plots the Oxford-Man realized volatility (from SPX2.rv) and overlays with the HMM expected volatility
with the observations set up SPX2.r. This graph is to show that the HMM is capable of reproducing the realized volatility.
Optionally the insert shows the relation between the return and volatility indicated by each state. This plot is also called
"volatility yield curve".
}
\examples{
\dontrun{
    ldhmm.oxford_man_plot_obs(NULL)
}
}
\author{
Stephen H. Lihn
}
\keyword{oxford}
