#' Boolean within
#'
#' returns `TRUE` if the first geometry is completely within the second
#' geometry
#'
#' @export
#' @param feature1,feature2 any [data-Geometry]/[data-Feature] objects
#' @template lint
#' @family boolean functions
#' @return a logical (`TRUE`/`FALSE`)
#' @examples
#' pt1 <- '[1, 2]'
#' l1 <- '[[1, 1], [1, 2], [1, 3], [1, 4]]'
#' lawn_boolean_within(lawn_point(pt1), lawn_linestring(l1))
lawn_boolean_within <- function(feature1, feature2, lint = FALSE) {
  lawnlint(list(feature1, feature2), lint)
  ct$eval(sprintf("var bdj = turf.booleanWithin(%s, %s);",
                  convert(feature1), convert(feature2)))
  ct$get("bdj")
}
