% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centerofmass.R
\name{lawn_center_of_mass}
\alias{lawn_center_of_mass}
\title{Center of mass}
\usage{
lawn_center_of_mass(x, lint = FALSE)
}
\arguments{
\item{x}{a \link{data-Feature} or \link{data-FeatureCollection}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a \link{data-Feature}<(\link{data-Point})>
}
\description{
Takes a \link{data-Feature} or a \link{data-FeatureCollection}
and returns its center of mass using formula
\url{https://en.wikipedia.org/wiki/Centroid#Centroid_of_polygon}
}
\examples{
x <- '{
 "type": "Feature",
 "properties": {},
 "geometry": {
     "type": "Polygon",
     "coordinates": [[
       [-112.072391,46.586591],
       [-112.072391,46.61761],
       [-112.028102,46.61761],
       [-112.028102,46.586591],
       [-112.072391,46.586591]
     ]]
   }
}'
lawn_center_of_mass(x)

lawn_center_of_mass(lawn_data$polygons_average)
}
\seealso{
Other measurements: \code{\link{lawn_along}},
  \code{\link{lawn_area}}, \code{\link{lawn_bbox_polygon}},
  \code{\link{lawn_bbox}}, \code{\link{lawn_bearing}},
  \code{\link{lawn_center}}, \code{\link{lawn_centroid}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_extent}},
  \code{\link{lawn_line_distance}},
  \code{\link{lawn_midpoint}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_pt2line_distance}},
  \code{\link{lawn_square}}
}
