% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{lawn_random}
\alias{lawn_random}
\title{Generate random data}
\usage{
lawn_random(type = "points", n = 10, bbox = NULL, num_vertices = NULL,
  max_radial_length = NULL)
}
\arguments{
\item{type}{type of features desired: 'points' or 'polygons'}

\item{n}{(integer) Number of features to generate}

\item{bbox}{A bounding box inside of which geometries are placed. In the case
of Point features, they are guaranteed to be within this bounds, while Polygon
features have their centroid within the bounds.}

\item{num_vertices}{Number options.vertices the number of vertices added to
polygon features.}

\item{max_radial_length}{Number    <optional> 10     the total number of decimal degrees
longitude or latitude that a polygon can extent outwards to from its center}
}
\value{
A \code{\link{data-FeatureCollection}}
}
\description{
Generates random \code{\link{data-GeoJSON}} data, including \code{\link{data-Point}}'s
and \code{\link{data-Polygon}}'s, for testing and experimentation
}
\examples{
## set of points
lawn_random(n = 2)
lawn_random(n = 10)
## set of polygons
lawn_random('polygons', 2)
lawn_random('polygons', 10)
# with options
lawn_random(bbox = c(-70, 40, -60, 60))
lawn_random(num_vertices = 5)
}
\seealso{
Other data functions: \code{\link{lawn_featurecollection}},
  \code{\link{lawn_feature}}, \code{\link{lawn_filter}},
  \code{\link{lawn_geometrycollection}},
  \code{\link{lawn_linestring}},
  \code{\link{lawn_multilinestring}},
  \code{\link{lawn_multipoint}},
  \code{\link{lawn_multipolygon}},
  \code{\link{lawn_point}}, \code{\link{lawn_polygon}},
  \code{\link{lawn_remove}}, \code{\link{lawn_sample}}
}

