% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.R
\name{lawn_tag}
\alias{lawn_tag}
\title{Spatial join of points and polygons}
\usage{
lawn_tag(points, polygons, poly_id, containing_polyid, lint = FALSE)
}
\arguments{
\item{points}{Input \code{\link{data-Point}}}

\item{polygons}{Input \code{\link{data-Polygon}} or \code{\link{data-MultiPolygon}}}

\item{poly_id}{property in polygons to add to joined Point features}

\item{containing_polyid}{property in points in which to store joined
property from polygons}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
points with containing_polyid property containing values from poly_id
}
\description{
Takes a set of \code{\link{data-Point}}'s and a set of
\code{\link{data-Polygon}}'s and performs a spatial join
}
\examples{
pts <- lawn_random(n = 30)
polys <- lawn_triangle_grid(c(-77.3876, 38.7198, -76.9482, 39.0277), 30, 'miles')
polys$features$properties <-
   data.frame(fill = c("#f92", "295"), stroke = 1:2, `fill-opacity` = 2:3)
lawn_tag(pts, polys, 'fill', 'marker-color')
}
\seealso{
Other joins: \code{\link{lawn_inside}},
  \code{\link{lawn_within}}
}

