% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/combine.R
\name{lawn_combine}
\alias{lawn_combine}
\title{Combine singular features into plural versions}
\usage{
lawn_combine(fc, lint = FALSE)
}
\arguments{
\item{fc}{A \code{\link{data-FeatureCollection}} of any type}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\description{
Combines a FeatureCollection of Point, LineString, or Polygon features into
MultiPoint, MultiLineString, or MultiPolygon features.
}
\examples{
# combine points
fc1 <- '{
 "type": "FeatureCollection",
 "features": [
   {
     "type": "Feature",
     "properties": {},
     "geometry": {
       "type": "Point",
       "coordinates": [19.026432, 47.49134]
     }
   }, {
     "type": "Feature",
     "properties": {},
     "geometry": {
       "type": "Point",
       "coordinates": [19.074497, 47.509548]
     }
   }
 ]
}'
lawn_combine(fc1)

# combine linestrings
fc2 <- '{
 "type": "FeatureCollection",
 "features": [
   {
     "type": "Feature",
     "properties": {},
     "geometry": {
       "type": "LineString",
       "coordinates": [
         [-21.964416, 64.148203],
         [-21.956176, 64.141316],
         [-21.93901, 64.135924],
         [-21.927337, 64.136673]
       ]
     }
   }, {
     "type": "Feature",
     "properties": {},
     "geometry": {
       "type": "LineString",
       "coordinates": [
         [-21.929054, 64.127985],
         [-21.912918, 64.134726],
         [-21.916007, 64.141016],
         [-21.930084, 64.14446]
       ]
     }
   }
 ]
}'
lawn_combine(fc2)
}

